/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenJDOMUtil;

public class MavenPlugin
implements Serializable {
    static final long serialVersionUID = -6113607480882347420L;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final boolean myDefault;
    private final boolean myExtensions;
    private final Element myConfiguration;
    private final List<Execution> myExecutions;
    private final List<MavenId> myDependencies;

    public MavenPlugin(String groupId, String artifactId, String version, boolean aDefault, boolean extensions, Element configuration, List<Execution> executions, List<MavenId> dependencies) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myDefault = aDefault;
        this.myExtensions = extensions;
        this.myConfiguration = configuration;
        this.myExecutions = executions;
        this.myDependencies = dependencies;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public boolean isDefault() {
        return this.myDefault;
    }

    public boolean isExtensions() {
        return this.myExtensions;
    }

    @Nullable
    public Element getConfigurationElement() {
        return this.myConfiguration;
    }

    public List<Execution> getExecutions() {
        return this.myExecutions;
    }

    public List<MavenId> getDependencies() {
        return this.myDependencies;
    }

    @Nullable
    public Element getGoalConfiguration(@NotNull String goal) {
        if (goal == null) {
            MavenPlugin.$$$reportNull$$$0(0);
        }
        for (Execution each : this.getExecutions()) {
            if (!each.getGoals().contains(goal)) continue;
            return each.getConfigurationElement();
        }
        return null;
    }

    public Element getExecutionConfiguration(@NotNull String executionId) {
        if (executionId == null) {
            MavenPlugin.$$$reportNull$$$0(1);
        }
        for (Execution each : this.getExecutions()) {
            if (!executionId.equals(each.getExecutionId())) continue;
            return each.getConfigurationElement();
        }
        return null;
    }

    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenPlugin that = (MavenPlugin)o;
        if (this.myDefault != that.myDefault) {
            return false;
        }
        if (this.myExtensions != that.myExtensions) {
            return false;
        }
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (!MavenJDOMUtil.areElementsEqual(this.myConfiguration, that.myConfiguration)) {
            return false;
        }
        if (this.myExecutions != null ? !this.myExecutions.equals(that.myExecutions) : that.myExecutions != null) {
            return false;
        }
        return !(this.myDependencies != null ? !this.myDependencies.equals(that.myDependencies) : that.myDependencies != null);
    }

    public int hashCode() {
        int result = this.myDefault ? 1 : 0;
        result = 31 * result + (this.myExtensions ? 1 : 0);
        result = 31 * result + (this.myGroupId != null ? this.myGroupId.hashCode() : 0);
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myConfiguration != null ? MavenJDOMUtil.getTreeHash(this.myConfiguration) : 0);
        result = 31 * result + (this.myExecutions != null ? this.myExecutions.hashCode() : 0);
        result = 31 * result + (this.myDependencies != null ? this.myDependencies.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/model/MavenPlugin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGoalConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutionConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Execution
    implements Serializable {
        private final List<String> myGoals;
        private final Element myConfiguration;
        private final String myExecutionId;
        private final String myPhase;

        public Execution(String executionId, List<String> goals, Element configuration) {
            this(executionId, null, goals, configuration);
        }

        public Execution(String executionId, String phase, List<String> goals, Element configuration) {
            this.myGoals = goals == null ? Collections.emptyList() : new ArrayList<String>(goals);
            this.myConfiguration = configuration;
            this.myExecutionId = executionId;
            this.myPhase = phase;
        }

        public String getExecutionId() {
            return this.myExecutionId;
        }

        public String getPhase() {
            return this.myPhase;
        }

        public List<String> getGoals() {
            return this.myGoals;
        }

        @Nullable
        public Element getConfigurationElement() {
            return this.myConfiguration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution that = (Execution)o;
            if (!this.myGoals.equals(that.myGoals)) {
                return false;
            }
            if (this.myExecutionId != null ? !this.myExecutionId.equals(that.myExecutionId) : that.myExecutionId != null) {
                return false;
            }
            if (this.myPhase != null ? !this.myPhase.equals(that.myPhase) : that.myPhase != null) {
                return false;
            }
            return MavenJDOMUtil.areElementsEqual(this.myConfiguration, that.myConfiguration);
        }

        public int hashCode() {
            int result = this.myGoals.hashCode();
            if (this.myExecutionId != null) {
                result = 31 * result + this.myExecutionId.hashCode();
            }
            if (this.myPhase != null) {
                result = 31 * result + this.myPhase.hashCode();
            }
            return result;
        }
    }
}

