/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GridDropLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GridSpanInsertProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.HorzInsertFeedbackPainter;
import com.intellij.uiDesigner.designSurface.VertInsertFeedbackPainter;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridInsertLocation
extends GridDropLocation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.designSurface.GridInsertLocation");
    public static final int INSERT_ARROW_SIZE = 3;
    public static final int INSERT_RECT_MIN_SIZE = 15;
    private GridInsertMode myMode;
    private boolean mySpanInsertMode;

    public GridInsertLocation(@NotNull RadContainer container, int row, int column, GridInsertMode mode) {
        if (container == null) {
            GridInsertLocation.$$$reportNull$$$0(0);
        }
        super(container, row, column);
        this.myMode = mode;
        assert (container.getLayoutManager().isGrid());
    }

    public GridInsertLocation normalize() {
        RadAbstractGridLayoutManager gridManager = this.myContainer.getGridLayoutManager();
        if (this.myMode == GridInsertMode.RowBefore && this.myRow > 0) {
            this.myMode = GridInsertMode.RowAfter;
            --this.myRow;
        } else if (this.myMode == GridInsertMode.ColumnBefore && this.myColumn > 0) {
            this.myMode = GridInsertMode.ColumnAfter;
            --this.myColumn;
        }
        if (this.myMode == GridInsertMode.RowAfter && gridManager.isGapCell(this.myContainer, true, this.myRow)) {
            --this.myRow;
        } else if (this.myMode == GridInsertMode.RowBefore && gridManager.isGapCell(this.myContainer, true, this.myRow)) {
            ++this.myRow;
        } else if (this.myMode == GridInsertMode.ColumnAfter && gridManager.isGapCell(this.myContainer, false, this.myColumn)) {
            --this.myColumn;
        } else if (this.myMode == GridInsertMode.ColumnBefore && gridManager.isGapCell(this.myContainer, false, this.myColumn)) {
            ++this.myColumn;
        }
        return this;
    }

    public GridInsertMode getMode() {
        return this.myMode;
    }

    public void setSpanInsertMode(boolean spanInsertMode) {
        this.mySpanInsertMode = spanInsertMode;
    }

    private boolean isColumnInsert() {
        return this.myMode == GridInsertMode.ColumnAfter || this.myMode == GridInsertMode.ColumnBefore;
    }

    private boolean isRowInsert() {
        return this.myMode == GridInsertMode.RowAfter || this.myMode == GridInsertMode.RowBefore;
    }

    public boolean isInsert() {
        return this.isColumnInsert() || this.isRowInsert();
    }

    private int getInsertCell() {
        return this.isRowInsert() ? this.myRow : this.myColumn;
    }

    private int getOppositeCell() {
        return this.isRowInsert() ? this.myColumn : this.myRow;
    }

    private boolean isInsertAfter() {
        return this.myMode == GridInsertMode.ColumnAfter || this.myMode == GridInsertMode.RowAfter;
    }

    @Override
    public boolean canDrop(ComponentDragObject dragObject) {
        int size;
        Rectangle rc = this.getDragObjectDimensions(dragObject, true);
        int n = size = this.isRowInsert() ? rc.width : rc.height;
        if (this.isInsertInsideComponent(size)) {
            LOG.debug("GridInsertLocation.canDrop()=false because insert inside component");
            return false;
        }
        LOG.debug("GridInsertLocation.canDrop()=true");
        return true;
    }

    private static boolean isSameCell(ComponentDragObject dragObject, boolean isRow) {
        if (dragObject.getComponentCount() == 0) {
            return true;
        }
        int cell = isRow ? dragObject.getRelativeRow(0) : dragObject.getRelativeCol(0);
        for (int i = 1; i < dragObject.getComponentCount(); ++i) {
            int cell2;
            int n = cell2 = isRow ? dragObject.getRelativeRow(i) : dragObject.getRelativeCol(i);
            if (cell2 == cell) continue;
            return false;
        }
        return true;
    }

    private boolean isInsertInsideComponent(int size) {
        int row;
        int endColumn = this.getInsertCell();
        if (this.isInsertAfter()) {
            ++endColumn;
        }
        for (int r = row = this.getOppositeCell(); r < row + size; ++r) {
            for (int col = 0; col < endColumn; ++col) {
                boolean isRow;
                RadComponent component = this.isColumnInsert() ? RadAbstractGridLayoutManager.getComponentAtGrid(this.getContainer(), r, col) : RadAbstractGridLayoutManager.getComponentAtGrid(this.getContainer(), col, r);
                if (component == null) continue;
                GridConstraints constraints = component.getConstraints();
                boolean bl = isRow = !this.isColumnInsert();
                if (constraints.getCell(isRow) + constraints.getSpan(isRow) <= endColumn || constraints.getSpan(isRow) <= 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
        int insertCol = this.getColumn();
        int insertRow = this.getRow();
        Rectangle feedbackRect = this.getGridFeedbackRect(dragObject, this.isColumnInsert(), this.isRowInsert(), false);
        if (feedbackRect == null) {
            feedbackLayer.removeFeedback();
            return;
        }
        Rectangle cellRect = this.getGridFeedbackCellRect(dragObject, this.isColumnInsert(), this.isRowInsert(), false);
        assert (cellRect != null);
        RadAbstractGridLayoutManager layoutManager = this.getContainer().getGridLayoutManager();
        int[] vGridLines = layoutManager.getVerticalGridLines(this.getContainer());
        int[] hGridLines = layoutManager.getHorizontalGridLines(this.getContainer());
        VertInsertFeedbackPainter painter = this.myMode == GridInsertMode.ColumnBefore || this.myMode == GridInsertMode.ColumnAfter ? VertInsertFeedbackPainter.INSTANCE : HorzInsertFeedbackPainter.INSTANCE;
        Rectangle rcFeedback = null;
        if (dragObject.getComponentCount() == 1) {
            int lastRowIndex;
            int lastColIndex = insertCol + dragObject.getColSpan(0);
            if (lastColIndex > vGridLines.length - 1) {
                lastColIndex = insertCol + 1;
            }
            if ((lastRowIndex = insertRow + dragObject.getRowSpan(0)) > hGridLines.length - 1) {
                lastRowIndex = insertRow + 1;
            }
            int cellWidth = vGridLines[lastColIndex] - vGridLines[insertCol];
            int cellHeight = hGridLines[lastRowIndex] - hGridLines[insertRow];
            RadComponent component = RadAbstractGridLayoutManager.getComponentAtGrid(this.getContainer(), insertRow, insertCol);
            if (component != null && this.mySpanInsertMode) {
                Rectangle bounds = component.getBounds();
                bounds.translate(-vGridLines[insertCol], -hGridLines[insertRow]);
                int spaceToRight = vGridLines[lastColIndex] - vGridLines[insertCol] - (bounds.x + bounds.width);
                int spaceBelow = hGridLines[lastRowIndex] - hGridLines[insertRow] - (bounds.y + bounds.height);
                if (this.myMode == GridInsertMode.RowBefore && bounds.y > 15) {
                    rcFeedback = new Rectangle(0, 0, cellWidth, bounds.y);
                } else if (this.myMode == GridInsertMode.RowAfter && spaceBelow > 15) {
                    rcFeedback = new Rectangle(0, bounds.y + bounds.height, cellWidth, spaceBelow);
                } else if (this.myMode == GridInsertMode.ColumnBefore && bounds.x > 15) {
                    rcFeedback = new Rectangle(0, 0, bounds.x, cellHeight);
                } else if (this.myMode == GridInsertMode.ColumnAfter && spaceToRight > 15) {
                    rcFeedback = new Rectangle(bounds.x + bounds.width, 0, spaceToRight, cellHeight);
                }
                if (rcFeedback != null) {
                    boolean spanInsertMode = false;
                    if (this.isRowInsert()) {
                        int columns = layoutManager.getGridColumnCount(this.getContainer());
                        for (int i = 0; i < columns; ++i) {
                            if (i == insertCol || RadAbstractGridLayoutManager.getComponentAtGrid(this.getContainer(), insertRow, i) == null) continue;
                            spanInsertMode = true;
                            break;
                        }
                    } else {
                        int rows = layoutManager.getGridRowCount(this.getContainer());
                        for (int i = 0; i < rows; ++i) {
                            if (i == insertRow || RadAbstractGridLayoutManager.getComponentAtGrid(this.getContainer(), i, insertCol) == null) continue;
                            spanInsertMode = true;
                            break;
                        }
                    }
                    if (!spanInsertMode) {
                        rcFeedback = null;
                    }
                }
                if (rcFeedback != null) {
                    rcFeedback.translate(vGridLines[insertCol], hGridLines[insertRow]);
                }
            }
            if (rcFeedback == null) {
                int remainingSize;
                Dimension initialSize;
                if (insertCol == layoutManager.getGridColumnCount(this.getContainer()) - 1 && this.myMode == GridInsertMode.ColumnAfter) {
                    initialSize = dragObject.getInitialSize(this.getContainer());
                    int feedbackX = vGridLines[vGridLines.length - 1] + layoutManager.getGapCellSize(this.myContainer, false);
                    remainingSize = this.getContainer().getDelegee().getWidth() - feedbackX;
                    if (!dragObject.isHGrow() && remainingSize > initialSize.width) {
                        rcFeedback = dragObject.isVGrow() || initialSize.height > cellHeight ? new Rectangle(feedbackX, hGridLines[insertRow], initialSize.width, cellHeight) : new Rectangle(feedbackX, hGridLines[insertRow] + (cellHeight - initialSize.height) / 2, initialSize.width, initialSize.height);
                    } else if (remainingSize >= 4) {
                        rcFeedback = new Rectangle(feedbackX, hGridLines[insertRow], remainingSize, cellHeight);
                    }
                } else if (insertRow == layoutManager.getGridRowCount(this.getContainer()) - 1 && this.myMode == GridInsertMode.RowAfter) {
                    initialSize = dragObject.getInitialSize(this.getContainer());
                    int feedbackY = hGridLines[hGridLines.length - 1] + layoutManager.getGapCellSize(this.myContainer, true);
                    remainingSize = this.getContainer().getDelegee().getHeight() - feedbackY;
                    if (!dragObject.isVGrow() && remainingSize > initialSize.height) {
                        rcFeedback = new Rectangle(vGridLines[insertCol], feedbackY, cellWidth, initialSize.height);
                    } else if (remainingSize >= 4) {
                        rcFeedback = new Rectangle(vGridLines[insertCol], feedbackY, cellWidth, remainingSize);
                    }
                }
            }
        }
        if (rcFeedback != null) {
            feedbackLayer.putFeedback(this.getContainer().getDelegee(), rcFeedback, this.getInsertFeedbackTooltip());
            return;
        }
        Rectangle rc = GridInsertLocation.getInsertFeedbackPosition(this.myMode, this.getContainer(), cellRect, feedbackRect);
        feedbackLayer.putFeedback(this.getContainer().getDelegee(), rc, painter, this.getInsertFeedbackTooltip());
    }

    private String getInsertFeedbackTooltip() {
        int displayRow = this.myRow + this.getContainer().getGridLayoutManager().getCellIndexBase();
        int displayColumn = this.myColumn + this.getContainer().getGridLayoutManager().getCellIndexBase();
        String displayName = this.getContainer().getDisplayName();
        switch (this.myMode) {
            case ColumnBefore: {
                return UIDesignerBundle.message("insert.feedback.before.col", displayName, displayRow, displayColumn);
            }
            case ColumnAfter: {
                return UIDesignerBundle.message("insert.feedback.after.col", displayName, displayRow, displayColumn);
            }
            case RowBefore: {
                return UIDesignerBundle.message("insert.feedback.before.row", displayName, displayColumn, displayRow);
            }
            case RowAfter: {
                return UIDesignerBundle.message("insert.feedback.after.row", displayName, displayColumn, displayRow);
            }
        }
        return null;
    }

    public static Rectangle getInsertFeedbackPosition(GridInsertMode mode, RadContainer container, Rectangle cellRect, Rectangle feedbackRect) {
        RadAbstractGridLayoutManager manager = container.getGridLayoutManager();
        int[] vGridLines = manager.getVerticalGridLines(container);
        int[] hGridLines = manager.getHorizontalGridLines(container);
        Rectangle rc = feedbackRect;
        int w = 4;
        switch (mode) {
            case ColumnBefore: {
                rc = new Rectangle(vGridLines[cellRect.x] - w, feedbackRect.y - 3, 2 * w, feedbackRect.height + 6);
                if (cellRect.x <= 0 || !manager.isGapCell(container, false, cellRect.x - 1)) break;
                rc.translate(-(vGridLines[cellRect.x] - vGridLines[cellRect.x - 1]) / 2, 0);
                break;
            }
            case ColumnAfter: {
                rc = new Rectangle(vGridLines[cellRect.x + cellRect.width + 1] - w, feedbackRect.y - 3, 2 * w, feedbackRect.height + 6);
                if (cellRect.x >= manager.getGridColumnCount(container) - 1 || !manager.isGapCell(container, false, cellRect.x + 1)) break;
                rc.translate((vGridLines[cellRect.x + 2] - vGridLines[cellRect.x + 1]) / 2, 0);
                break;
            }
            case RowBefore: {
                rc = new Rectangle(feedbackRect.x - 3, hGridLines[cellRect.y] - w, feedbackRect.width + 6, 2 * w);
                if (cellRect.y <= 0 || !manager.isGapCell(container, true, cellRect.y - 1)) break;
                rc.translate(0, -(hGridLines[cellRect.y] - hGridLines[cellRect.y - 1]) / 2);
                break;
            }
            case RowAfter: {
                rc = new Rectangle(feedbackRect.x - 3, hGridLines[cellRect.y + cellRect.height + 1] - w, feedbackRect.width + 6, 2 * w);
                if (cellRect.y >= manager.getGridRowCount(container) - 1 || !manager.isGapCell(container, true, cellRect.y + 1)) break;
                rc.translate(0, (hGridLines[cellRect.y + 2] - hGridLines[cellRect.y + 1]) / 2);
            }
        }
        return rc;
    }

    @Override
    public void processDrop(GuiEditor editor, RadComponent[] components, @Nullable GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
        int row = this.getRow();
        int col = this.getColumn();
        RadContainer container = this.getContainer();
        boolean canGrow = this.isRowInsert() ? dragObject.isVGrow() : dragObject.isHGrow();
        int cell = this.isRowInsert() ? this.getRow() : this.getColumn();
        int cellsToInsert = 1;
        if (components.length > 0) {
            int size;
            int cellSize = container.getGridCellCount(this.isRowInsert());
            Rectangle rc = this.getDragObjectDimensions(dragObject, cell < cellSize - 1);
            int n = size = this.isRowInsert() ? rc.height : rc.width;
            if (size > 0) {
                cellsToInsert = size;
            }
        }
        GridSpanInsertProcessor spanInsertProcessor = this.mySpanInsertMode && dragObject.getComponentCount() == 1 ? new GridSpanInsertProcessor(container, this.getRow(), this.getColumn(), this.myMode, dragObject) : null;
        int newCell = GridInsertLocation.insertGridCells(container, cell, cellsToInsert, canGrow, this.isRowInsert(), !this.isInsertAfter(), constraintsToAdjust);
        if (this.isRowInsert()) {
            row = newCell;
        } else {
            col = newCell;
        }
        if (components.length > 0) {
            if (spanInsertProcessor != null) {
                spanInsertProcessor.doBefore(newCell);
            }
            GridInsertLocation.dropIntoGrid(container, components, row, col, dragObject);
            if (spanInsertProcessor != null) {
                spanInsertProcessor.doAfter(newCell);
            }
        }
    }

    private static int insertGridCells(RadContainer container, int cell, int cellsToInsert, boolean canGrow, boolean isRow, boolean isBefore, GridConstraints[] constraintsToAdjust) {
        int insertedCells = 1;
        for (int i = 0; i < cellsToInsert; ++i) {
            insertedCells = container.getGridLayoutManager().insertGridCells(container, cell, isRow, isBefore, canGrow);
        }
        if (!isBefore) {
            cell += insertedCells;
        }
        GridInsertLocation.checkAdjustConstraints(constraintsToAdjust, isRow, cell, insertedCells);
        return cell;
    }

    private static void checkAdjustConstraints(@Nullable GridConstraints[] constraintsToAdjust, boolean isRow, int index, int count) {
        if (constraintsToAdjust != null) {
            for (GridConstraints constraints : constraintsToAdjust) {
                GridChangeUtil.adjustConstraintsOnInsert(constraints, isRow, index, count);
            }
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "GridInsertLocation(" + this.myMode.toString() + ", row=" + this.getRow() + ", col=" + this.getColumn() + ")";
    }

    @Override
    @Nullable
    public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
        if (this.isRowInsert()) {
            if (direction == ComponentDropLocation.Direction.RIGHT) {
                if (this.getColumn() < this.myContainer.getGridColumnCount() - 1) {
                    return new GridInsertLocation(this.myContainer, this.getRow(), FormEditingUtil.adjustForGap(this.myContainer, this.getColumn() + 1, false, 1), this.getMode());
                }
                return new GridInsertLocation(this.myContainer, this.getRow(), this.getColumn(), GridInsertMode.ColumnAfter);
            }
            if (direction == ComponentDropLocation.Direction.LEFT) {
                if (this.getColumn() > 0) {
                    return new GridInsertLocation(this.myContainer, this.getRow(), FormEditingUtil.adjustForGap(this.myContainer, this.getColumn() - 1, false, -1), this.getMode());
                }
                return new GridInsertLocation(this.myContainer, this.getRow(), this.getColumn(), GridInsertMode.ColumnBefore);
            }
            if (direction == ComponentDropLocation.Direction.DOWN || direction == ComponentDropLocation.Direction.UP) {
                int adjRow;
                int n = adjRow = this.myMode == GridInsertMode.RowAfter ? this.getRow() : this.getRow() - 1;
                if (direction == ComponentDropLocation.Direction.DOWN && adjRow + 1 < this.myContainer.getGridRowCount()) {
                    return new GridDropLocation(this.myContainer, FormEditingUtil.adjustForGap(this.myContainer, adjRow + 1, true, 1), this.getColumn());
                }
                if (direction == ComponentDropLocation.Direction.UP && adjRow >= 0) {
                    return new GridDropLocation(this.myContainer, FormEditingUtil.adjustForGap(this.myContainer, adjRow, true, -1), this.getColumn());
                }
                return this.getLocationAtParent(direction);
            }
        } else {
            if (direction == ComponentDropLocation.Direction.DOWN) {
                if (this.getRow() < this.myContainer.getGridRowCount() - 1) {
                    return new GridInsertLocation(this.myContainer, FormEditingUtil.adjustForGap(this.myContainer, this.getRow() + 1, true, 1), this.getColumn(), this.getMode());
                }
                return new GridInsertLocation(this.myContainer, this.getRow(), this.getColumn(), GridInsertMode.RowAfter);
            }
            if (direction == ComponentDropLocation.Direction.UP) {
                if (this.getRow() > 0) {
                    return new GridInsertLocation(this.myContainer, FormEditingUtil.adjustForGap(this.myContainer, this.getRow() - 1, true, -1), this.getColumn(), this.getMode());
                }
                return new GridInsertLocation(this.myContainer, this.getRow(), this.getColumn(), GridInsertMode.RowBefore);
            }
            if (direction == ComponentDropLocation.Direction.LEFT || direction == ComponentDropLocation.Direction.RIGHT) {
                int adjCol;
                int n = adjCol = this.myMode == GridInsertMode.ColumnAfter ? this.getColumn() : this.getColumn() - 1;
                if (direction == ComponentDropLocation.Direction.RIGHT && adjCol + 1 < this.myContainer.getGridColumnCount()) {
                    return new GridDropLocation(this.myContainer, this.getRow(), FormEditingUtil.adjustForGap(this.myContainer, adjCol + 1, false, 1));
                }
                if (direction == ComponentDropLocation.Direction.LEFT && adjCol >= 0) {
                    return new GridDropLocation(this.myContainer, this.getRow(), FormEditingUtil.adjustForGap(this.myContainer, adjCol, false, -1));
                }
                return this.getLocationAtParent(direction);
            }
        }
        return null;
    }

    private ComponentDropLocation getLocationAtParent(ComponentDropLocation.Direction direction) {
        RadContainer parent = this.myContainer.getParent();
        if (parent.getLayoutManager().isGrid()) {
            GridConstraints c = this.myContainer.getConstraints();
            switch (direction) {
                case LEFT: {
                    return new GridInsertLocation(parent, c.getRow(), c.getColumn(), GridInsertMode.ColumnBefore);
                }
                case RIGHT: {
                    return new GridInsertLocation(parent, c.getRow(), c.getColumn() + c.getColSpan() - 1, GridInsertMode.ColumnAfter);
                }
                case UP: {
                    return new GridInsertLocation(parent, c.getRow(), c.getColumn(), GridInsertMode.RowBefore);
                }
                case DOWN: {
                    return new GridInsertLocation(parent, c.getRow() + c.getRowSpan() - 1, c.getColumn(), GridInsertMode.RowAfter);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/uiDesigner/designSurface/GridInsertLocation", "<init>"));
    }
}

