/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceInForm
implements PsiReference {
    protected final PsiPlainTextFile myFile;
    private final RangeMarker myRangeMarker;

    protected ReferenceInForm(PsiPlainTextFile file, TextRange range) {
        this.myFile = file;
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile.getViewProvider().getVirtualFile());
        this.myRangeMarker = document.createRangeMarker(range);
    }

    @NotNull
    public PsiElement getElement() {
        PsiPlainTextFile psiPlainTextFile = this.myFile;
        if (psiPlainTextFile == null) {
            ReferenceInForm.$$$reportNull$$$0(0);
        }
        return psiPlainTextFile;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            ReferenceInForm.$$$reportNull$$$0(1);
        }
        return this.handleElementRenameBase(newElementName);
    }

    private PsiElement handleElementRenameBase(String newElementName) {
        this.updateRangeText(newElementName);
        return this.myFile;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.create((Segment)this.myRangeMarker);
        if (textRange == null) {
            ReferenceInForm.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeText();
        if (string == null) {
            ReferenceInForm.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void updateRangeText(String text) {
        Document document = this.myRangeMarker.getDocument();
        document.replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), (CharSequence)text);
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitDocument(document);
    }

    public String getRangeText() {
        return this.myRangeMarker.getDocument().getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset()).toString();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ReferenceInForm.$$$reportNull$$$0(4);
        }
        return this.resolve() == element;
    }

    public boolean isSoft() {
        return true;
    }

    protected PsiElement handleFileRename(String newElementName, @NonNls String extension, boolean includeExtensionInReference) {
        String extensionInReference;
        String currentName = this.getRangeText();
        String baseName = newElementName.endsWith(extension) ? newElementName.substring(0, newElementName.length() - extension.length()) : newElementName;
        int slashIndex = currentName.lastIndexOf(47);
        String string = extensionInReference = includeExtensionInReference ? extension : "";
        if (slashIndex >= 0) {
            String prefix = currentName.substring(0, slashIndex);
            return this.handleElementRenameBase(prefix + "/" + baseName + extensionInReference);
        }
        return this.handleElementRenameBase(baseName + extensionInReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/ReferenceInForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/ReferenceInForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

