/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.hash.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenPropertiesPanel;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilder;

public class SelectPropertiesStep
extends ModuleWizardStep {
    private final Project myProjectOrNull;
    private final MavenModuleBuilder myBuilder;
    private JPanel myMainPanel;
    private JPanel myEnvironmentPanel;
    private JPanel myPropertiesPanel;
    private MavenEnvironmentForm myEnvironmentForm;
    private MavenPropertiesPanel myMavenPropertiesPanel;
    private final Map<String, String> myAvailableProperties;

    public SelectPropertiesStep(@Nullable Project project, MavenModuleBuilder builder) {
        this.$$$setupUI$$$();
        this.myAvailableProperties = new HashMap();
        this.myProjectOrNull = project;
        this.myBuilder = builder;
        this.initComponents();
    }

    private void initComponents() {
        this.myEnvironmentForm = new MavenEnvironmentForm();
        Project project = this.myProjectOrNull == null ? ProjectManager.getInstance().getDefaultProject() : this.myProjectOrNull;
        this.myEnvironmentForm.getData(MavenProjectsManager.getInstance(project).getGeneralSettings().clone());
        this.myEnvironmentPanel.add((Component)this.myEnvironmentForm.createComponent(), "Center");
        this.myMavenPropertiesPanel = new MavenPropertiesPanel(this.myAvailableProperties);
        this.myPropertiesPanel.add((Component)((Object)this.myMavenPropertiesPanel));
    }

    public void updateStep() {
        MavenArchetype archetype = this.myBuilder.getArchetype();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        MavenId projectId = this.myBuilder.getProjectId();
        props.put("groupId", projectId.getGroupId());
        props.put("artifactId", projectId.getArtifactId());
        props.put("version", projectId.getVersion());
        props.put("archetypeGroupId", archetype.groupId);
        props.put("archetypeArtifactId", archetype.artifactId);
        props.put("archetypeVersion", archetype.version);
        if (archetype.repository != null) {
            props.put("archetypeRepository", archetype.repository);
        }
        this.myMavenPropertiesPanel.setDataFromMap(props);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean isStepVisible() {
        return this.myBuilder.getArchetype() != null;
    }

    public boolean validate() throws ConfigurationException {
        File mavenHome = MavenUtil.resolveMavenHomeDirectory(this.myEnvironmentForm.getMavenHome());
        if (mavenHome == null) {
            throw new ConfigurationException("Maven home directory is not specified");
        }
        if (!MavenUtil.isValidMavenHome(mavenHome)) {
            throw new ConfigurationException("Maven home directory is invalid: " + mavenHome);
        }
        return true;
    }

    public void updateDataModel() {
        this.myBuilder.setEnvironmentForm(this.myEnvironmentForm);
        this.myBuilder.setPropertiesToCreateByArtifact(this.myMavenPropertiesPanel.getDataAsMap());
    }

    public String getHelpId() {
        return "New_Projects_from_Scratch_Maven_Settings_Page";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnvironmentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 300), null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Properties", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

