/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

public class MavenRehighlighter {
    private final MergingUpdateQueue queue;

    public MavenRehighlighter(@NotNull Project project) {
        if (project == null) {
            MavenRehighlighter.$$$reportNull$$$0(0);
        }
        this.queue = new MergingUpdateQueue(this.getClass().getSimpleName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project, null, true);
        this.queue.setPassThrough(false);
    }

    public static void rehighlight(@NotNull Project project) {
        if (project == null) {
            MavenRehighlighter.$$$reportNull$$$0(1);
        }
        MavenRehighlighter.rehighlight(project, null);
    }

    public static void rehighlight(@NotNull Project project, @Nullable MavenProject mavenProject) {
        if (project == null) {
            MavenRehighlighter.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                ((MavenRehighlighter)ServiceManager.getService((Project)project, MavenRehighlighter.class)).queue.queue((Update)new MyUpdate(project, mavenProject));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenRehighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rehighlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUpdate
    extends Update {
        private final Project myProject;
        private final MavenProject myMavenProject;

        MyUpdate(Project project, MavenProject mavenProject) {
            super((Object)project);
            this.myProject = project;
            this.myMavenProject = mavenProject;
        }

        public void run() {
            if (this.myMavenProject == null) {
                for (VirtualFile each : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    this.doRehighlightMavenFile(each);
                }
            } else {
                this.doRehighlightMavenFile(this.myMavenProject.getFile());
            }
        }

        private void doRehighlightMavenFile(VirtualFile file) {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(file);
            if (doc == null) {
                return;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(doc);
            if (psi == null) {
                return;
            }
            if (!MavenDomUtil.isMavenFile(psi)) {
                return;
            }
            DaemonCodeAnalyzer daemon = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            daemon.restart(psi);
        }

        public boolean canEat(Update update) {
            return this.myMavenProject == null || this.myMavenProject == ((MyUpdate)update).myMavenProject;
        }
    }

    private static final class MavenRehighlighterPostStartupActivity
    implements StartupActivity,
    DumbAware {
        private MavenRehighlighterPostStartupActivity() {
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                MavenRehighlighterPostStartupActivity.$$$reportNull$$$0(0);
            }
            MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
            mavenProjectManager.addManagerListener(new MavenProjectsManager.Listener(){

                @Override
                public void activated() {
                    MavenRehighlighter.rehighlight(project, null);
                }

                @Override
                public void projectsScheduled() {
                }

                @Override
                public void importAndResolveScheduled() {
                }
            });
            mavenProjectManager.addProjectsTreeListener(new MavenProjectsTree.Listener(){

                @Override
                public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                    if (updated == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (deleted == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    for (Pair<MavenProject, MavenProjectChanges> each : updated) {
                        MavenRehighlighter.rehighlight(project, (MavenProject)each.first);
                    }
                }

                @Override
                public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                    if (projectWithChanges == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    MavenRehighlighter.rehighlight(project, (MavenProject)projectWithChanges.first);
                }

                @Override
                public void pluginsResolved(@NotNull MavenProject mavenProject) {
                    if (mavenProject == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    MavenRehighlighter.rehighlight(project, mavenProject);
                }

                @Override
                public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                    if (projectWithChanges == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    MavenRehighlighter.rehighlight(project, (MavenProject)projectWithChanges.first);
                }

                @Override
                public void artifactsDownloaded(@NotNull MavenProject mavenProject) {
                    if (mavenProject == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    MavenRehighlighter.rehighlight(project, mavenProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "updated";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "deleted";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectWithChanges";
                            break;
                        }
                        case 3: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "mavenProject";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenRehighlighter$MavenRehighlighterPostStartupActivity$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectsUpdated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectResolved";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginsResolved";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "foldersResolved";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "artifactsDownloaded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenRehighlighter$MavenRehighlighterPostStartupActivity", "runActivity"));
        }
    }
}

