/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGroovyConsoleFilter;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenScalaConsoleFilter;
import org.jetbrains.idea.maven.project.MavenTestConsoleFilter;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Deprecated
public class MavenConsoleImpl
extends MavenConsole {
    private static final Key<MavenConsoleImpl> CONSOLE_KEY = Key.create((String)"MAVEN_CONSOLE_KEY");
    private static final String CONSOLE_FILTER_REGEXP = "(?:^|(?:\\[\\w+\\]\\s*)( /)?)$FILE_PATH$:\\[$LINE$,$COLUMN$]";
    private final String myTitle;
    private final Project myProject;
    private final ConsoleView myConsoleView;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final Pair<MavenRunnerParameters, MavenRunnerSettings> myParametersAndSettings;

    public MavenConsoleImpl(String title, Project project) {
        this(title, project, null);
    }

    public MavenConsoleImpl(String title, Project project, Pair<MavenRunnerParameters, MavenRunnerSettings> parametersAndSettings) {
        super(MavenConsoleImpl.getGeneralSettings(project).getLoggingLevel(), MavenConsoleImpl.getGeneralSettings(project).isPrintErrorStackTraces());
        this.myTitle = title;
        this.myProject = project;
        this.myConsoleView = this.createConsoleView();
        this.myParametersAndSettings = parametersAndSettings;
    }

    private static MavenGeneralSettings getGeneralSettings(Project project) {
        return MavenProjectsManager.getInstance(project).getGeneralSettings();
    }

    public ConsoleView createConsoleView() {
        return MavenConsoleImpl.createConsoleBuilder(this.myProject).getConsole();
    }

    public static Filter[] getMavenConsoleFilters(final @NotNull Project project) {
        if (project == null) {
            MavenConsoleImpl.$$$reportNull$$$0(0);
        }
        return new Filter[]{new RegexpFilter(project, CONSOLE_FILTER_REGEXP){

            @Nullable
            protected HyperlinkInfo createOpenFileHyperlink(String fileName, int line, int column) {
                String projectPath;
                VirtualFile[] roots;
                HyperlinkInfo res = super.createOpenFileHyperlink(fileName, line, column);
                if (res == null && fileName.startsWith("\\") && SystemInfo.isWindows && (roots = ProjectRootManager.getInstance((Project)project).getContentRoots()).length > 0 && (projectPath = roots[0].getPath()).matches("[A-Z]:[\\\\/].+")) {
                    res = super.createOpenFileHyperlink(projectPath.charAt(0) + ":" + fileName, line, column);
                }
                return res;
            }
        }, new MavenGroovyConsoleFilter(project), new MavenScalaConsoleFilter(project), new MavenTestConsoleFilter()};
    }

    public static TextConsoleBuilder createConsoleBuilder(Project project) {
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder.filters(MavenConsoleImpl.getMavenConsoleFilters(project));
        return builder;
    }

    @Override
    public boolean canPause() {
        return this.myConsoleView.canPause();
    }

    @Override
    public boolean isOutputPaused() {
        return this.myConsoleView.isOutputPaused();
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
        this.myConsoleView.setOutputPaused(outputPaused);
    }

    public Pair<MavenRunnerParameters, MavenRunnerSettings> getParametersAndSettings() {
        return this.myParametersAndSettings;
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsoleView.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                MavenConsoleImpl.this.ensureAttachedToToolWindow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenConsoleImpl$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type) {
        ConsoleViewContentType contentType;
        this.ensureAttachedToToolWindow();
        switch (type) {
            case SYSTEM: {
                contentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case ERROR: {
                contentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        this.myConsoleView.print(text, contentType);
    }

    private void ensureAttachedToToolWindow() {
        if (!this.isOpen.compareAndSet(false, true)) {
            return;
        }
        MavenUtil.invokeLater(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            Content content = ContentFactory.SERVICE.getInstance().createContent(this.myConsoleView.getComponent(), this.myTitle, true);
            content.putUserData(CONSOLE_KEY, (Object)this);
            messageView.getContentManager().addContent(content);
            messageView.getContentManager().setSelectedContent(content);
            for (Content each : messageView.getContentManager().getContents()) {
                MavenConsoleImpl console;
                if (each.isPinned() || each == content || (console = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY)) == null || !this.myTitle.equals(console.myTitle) || !console.isFinished()) continue;
                messageView.getContentManager().removeContent(each, true);
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
            if (!toolWindow.isActive()) {
                toolWindow.activate(null, false);
            }
        });
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
        for (Content each : messageView.getContentManager().getContents()) {
            MavenConsoleImpl console = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY);
            if (console == null) continue;
            messageView.getContentManager().removeContent(each, true);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenConsoleImpl", "getMavenConsoleFilters"));
    }
}

