/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;

@ApiStatus.Experimental
public class MavenLogOutputParser
implements BuildOutputParser {
    private boolean myCompleted = false;
    private final List<MavenLoggedEventParser> myRegisteredEvents;
    private final ExternalSystemTaskId myTaskId;

    public MavenLogOutputParser(ExternalSystemTaskId taskId, List<MavenLoggedEventParser> registeredEvents) {
        this.myRegisteredEvents = registeredEvents;
        this.myTaskId = taskId;
    }

    public void finish(Consumer<? super BuildEvent> messageConsumer) {
        this.completeParsers(messageConsumer);
        if (!this.myCompleted) {
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "Maven run", (EventResult)new FailureResultImpl((Throwable)new Exception())));
        }
    }

    private void completeParsers(Consumer<? super BuildEvent> messageConsumer) {
        for (MavenLoggedEventParser parser : this.myRegisteredEvents) {
            parser.finish(this.myTaskId, messageConsumer);
        }
    }

    public boolean parse(String line, BuildOutputInstantReader reader, Consumer<? super BuildEvent> messageConsumer) {
        if (this.myCompleted) {
            return false;
        }
        MavenLogEntryReader.MavenLogEntry logLine = MavenLogOutputParser.nextLine(line);
        if (logLine == null || StringUtil.isEmptyOrSpaces((String)logLine.myLine)) {
            return false;
        }
        MavenLogEntryReader mavenLogReader = MavenLogOutputParser.wrapReader(reader);
        for (MavenLoggedEventParser event : this.myRegisteredEvents) {
            if (!event.supportsType(logLine.myType) || !event.checkLogLine(this.myTaskId, logLine, mavenLogReader, messageConsumer)) continue;
            return true;
        }
        return this.checkComplete(messageConsumer, logLine);
    }

    private static MavenLogEntryReader wrapReader(final BuildOutputInstantReader reader) {
        return new MavenLogEntryReader(){

            @Override
            public void pushBack() {
                reader.pushBack();
            }

            @Override
            @Nullable
            public MavenLogEntryReader.MavenLogEntry readLine() {
                return MavenLogOutputParser.nextLine(reader.readLine());
            }
        };
    }

    private boolean checkComplete(Consumer<? super BuildEvent> messageConsumer, MavenLogEntryReader.MavenLogEntry logLine) {
        if (logLine.myLine.equals("BUILD FAILURE")) {
            this.completeParsers(messageConsumer);
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "Maven run", (EventResult)new FailureResultImpl((Throwable)new Exception())));
            this.myCompleted = true;
            return true;
        }
        if (logLine.myLine.equals("BUILD SUCCESS")) {
            this.completeParsers(messageConsumer);
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "Maven run", (EventResult)new SuccessResultImpl()));
            this.myCompleted = true;
            return true;
        }
        return false;
    }

    @Nullable
    private static MavenLogEntryReader.MavenLogEntry nextLine(String line) {
        if (line == null) {
            return null;
        }
        return new MavenLogEntryReader.MavenLogEntry(line);
    }
}

