/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.JavaTestUtil;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerTestCase
extends ExecutionWithDebuggerToolsTestCase {
    protected static final int DEFAULT_ADDRESS = 3456;
    protected DebuggerSession myDebuggerSession;
    private final AtomicInteger myRestart = new AtomicInteger();
    private static final int MAX_RESTARTS = 3;
    private volatile UsefulTestCase.TestDisposable myTestRootDisposable;
    private final List<Runnable> myTearDownRunnables = new ArrayList<Runnable>();
    private CompilerManagerImpl myCompilerManager;

    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
            if (this.myDebugProcess != null) {
                this.myDebugProcess.stop(true);
                this.myDebugProcess.waitFor();
            }
            this.myTearDownRunnables.forEach(Runnable::run);
            this.myTearDownRunnables.clear();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
        if (this.myCompilerManager != null) {
            DebuggerTestCase.assertTrue((boolean)this.myCompilerManager.awaitNettyThreadPoolTermination(1L, TimeUnit.MINUTES));
            this.myCompilerManager = null;
        }
    }

    protected void initApplication() throws Exception {
        super.initApplication();
        JavaTestUtil.setupTestJDK(this.getTestRootDisposable());
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        DebuggerSettings.getInstance().SKIP_CONSTRUCTORS = false;
        DebuggerSettings.getInstance().SKIP_GETTERS = false;
        NodeRendererSettings.getInstance().getClassRenderer().SHOW_DECLARED_TYPE = true;
    }

    @Override
    protected void runTest() throws Throwable {
        super.runTest();
        if (this.getDebugProcess() != null) {
            this.getDebugProcess().getProcessHandler().startNotify();
            this.waitProcess(this.getDebugProcess().getProcessHandler());
            this.waitForCompleted();
            DebuggerTestCase.assertNull((Object)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(this.getDebugProcess().getProcessHandler()));
            this.myDebuggerSession = null;
        }
        this.myRestart.set(0);
        this.throwExceptionsIfAny();
        this.checkTestOutput();
    }

    private boolean needsRestart() {
        int restart = this.myRestart.get();
        return restart > 0 && restart <= 3;
    }

    @Override
    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            DebuggerTestCase.$$$reportNull$$$0(0);
        }
        this.myTestRootDisposable = new UsefulTestCase.TestDisposable((UsefulTestCase)this);
        super.runBareRunnable(runnable);
        while (this.needsRestart()) {
            assert (this.myTestRootDisposable.isDisposed());
            this.myTestRootDisposable = new UsefulTestCase.TestDisposable((UsefulTestCase)this);
            super.runBareRunnable(runnable);
        }
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        UsefulTestCase.TestDisposable testDisposable = this.myTestRootDisposable;
        if (testDisposable == null) {
            DebuggerTestCase.$$$reportNull$$$0(1);
        }
        return testDisposable;
    }

    protected void checkTestOutput() throws Exception {
        this.getChecker().checkValid(this.getTestProjectJdk());
    }

    protected void disposeSession(DebuggerSession debuggerSession) {
        UIUtil.invokeAndWaitIfNeeded(() -> ((DebuggerSession)debuggerSession).dispose());
    }

    protected void createLocalProcess(String className) throws ExecutionException {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebuggerSession = this.createLocalProcess(0, this.createJavaParameters(className));
        this.myDebugProcess = this.myDebuggerSession.getProcess();
    }

    protected DebuggerSession createLocalSession(final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaParameters, (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)false);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration()).build();
        JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return this.getJavaParameters().toCommandLine();
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                this.myDebuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration()).build(), (RunProfileState)javaCommandLineState, debugParameters, false));
                XDebuggerManager.getInstance((Project)this.myProject).startSession(javaCommandLineState.getEnvironment(), new XDebugProcessStarter(){

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)DebuggerTestCase.this.myDebuggerSession);
                        if (javaDebugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return javaDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
        this.myDebugProcess = this.myDebuggerSession.getProcess();
        this.myDebugProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebuggerTestCase.assertNotNull((Object)this.myDebuggerSession);
        DebuggerTestCase.assertNotNull((Object)this.myDebugProcess);
        return this.myDebuggerSession;
    }

    protected DebuggerSession createLocalProcess(int transport, final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = transport;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.setLocal(true);
        debuggerRunnerSettings.setTransport(transport);
        debuggerRunnerSettings.setDebugPort(transport == 0 ? "0" : String.valueOf(3456));
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration()).build();
        JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return this.getJavaParameters().toCommandLine();
            }
        };
        RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaCommandLineState.getJavaParameters(), (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)true);
        DebuggerSession[] debuggerSession = new DebuggerSession[]{null};
        UIUtil.invokeAndWaitIfNeeded(() -> {
            try {
                debuggerSession[0] = this.attachVirtualMachine(javaCommandLineState, javaCommandLineState.getEnvironment(), debugParameters, false);
            }
            catch (ExecutionException e) {
                DebuggerTestCase.fail((String)e.getMessage());
            }
        });
        ProcessHandler processHandler = debuggerSession[0].getProcess().getProcessHandler();
        debuggerSession[0].getProcess().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    5.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$5";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession[0];
    }

    private static String generateShmemAddress() {
        return "javadebug_" + (int)(Math.random() * 1000.0);
    }

    protected DebuggerSession createRemoteProcess(int transport, boolean serverMode, JavaParameters javaParameters) throws ExecutionException {
        DebuggerSession debuggerSession;
        boolean useSockets = transport == 0;
        RemoteConnection remoteConnection = new RemoteConnection(useSockets, "127.0.0.1", useSockets ? String.valueOf(3456) : DebuggerTestCase.generateShmemAddress(), serverMode);
        String launchCommandLine = remoteConnection.getLaunchCommandLine();
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onthrow=<FQ exception class name>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onuncaught=<y/n>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)"suspend=n", (String)"suspend=y");
        StringTokenizer tokenizer = new StringTokenizer(launchCommandLine);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            javaParameters.getVMParametersList().add(token);
        }
        GeneralCommandLine commandLine = javaParameters.toCommandLine();
        if (serverMode) {
            debuggerSession = this.attachVM(remoteConnection, false);
            commandLine.createProcess();
        } else {
            commandLine.createProcess();
            debuggerSession = this.attachVM(remoteConnection, true);
        }
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession attachVM(RemoteConnection remoteConnection, boolean pollConnection) {
        RemoteStateState remoteState = new RemoteStateState(this.myProject, remoteConnection);
        DebuggerSession[] debuggerSession = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded(() -> this.lambda$attachVM$2(debuggerSession, (RemoteState)remoteState, remoteConnection, pollConnection));
        debuggerSession[0].getProcess().getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    6.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$6";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return debuggerSession[0];
    }

    protected void createBreakpoints(String className) {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((Object)psiClass);
            return psiClass.getContainingFile();
        });
        this.createBreakpoints(psiFile);
    }

    protected EvaluationContextImpl createEvaluationContext(SuspendContextImpl suspendContext) {
        try {
            StackFrameProxyImpl proxy = suspendContext.getFrameProxy();
            DebuggerTestCase.assertNotNull((Object)proxy);
            return new EvaluationContextImpl(suspendContext, proxy, (Value)proxy.thisObject());
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    private void waitForCompleted() {
        final SynchronizationBasedSemaphore s = new SynchronizationBasedSemaphore();
        s.down();
        final InvokeThread.WorkerThreadRequest request = this.getDebugProcess().getManagerThread().getCurrentRequest();
        Thread thread = new Thread("Joining " + request){

            @Override
            public void run() {
                try {
                    request.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        if (request.isDone()) {
            thread.interrupt();
        }
        this.waitFor(() -> {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.invokeRatherLater(new DebuggerCommandImpl(){

            protected void action() {
                LOG.assertTrue(false);
            }

            protected void commandCancelled() {
                DebuggerTestCase.this.invokeRatherLater(new DebuggerCommandImpl(){

                    protected void action() {
                        LOG.assertTrue(false);
                    }

                    protected void commandCancelled() {
                        s.up();
                    }
                });
            }
        });
        this.waitFor(s::waitFor);
        this.myCompilerManager = (CompilerManagerImpl)CompilerManager.getInstance(this.getProject());
        this.myCompilerManager.waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES);
    }

    private DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext, StackFrameProxyImpl stackFrame) {
        DebuggerSession[] session = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded(() -> {
            session[0] = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getSession((DebugProcess)suspendContext.getDebugProcess());
        });
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext((DebuggerSession)session[0], (SuspendContextImpl)suspendContext, (ThreadReferenceProxyImpl)(stackFrame != null ? stackFrame.threadProxy() : null), (StackFrameProxyImpl)stackFrame);
        debuggerContext.initCaches();
        return debuggerContext;
    }

    public DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext) {
        return this.createDebuggerContext(suspendContext, suspendContext.getFrameProxy());
    }

    protected void printLocation(SuspendContextImpl suspendContext) {
        try {
            Location location = suspendContext.getFrameProxy().location();
            String message = "paused at " + location.sourceName() + ":" + location.lineNumber();
            this.println(message, ProcessOutputTypes.SYSTEM);
        }
        catch (Throwable e) {
            this.addException(e);
        }
    }

    protected void createBreakpointInHelloWorld() {
        DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("HelloWorld", GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((Object)psiClass);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiClass.getContainingFile());
            breakpointManager.addLineBreakpoint(document, 3);
        }, (ModalityState)ApplicationManager.getApplication().getDefaultModalityState());
    }

    protected void createHelloWorldProcessWithBreakpoint() throws ExecutionException {
        this.createLocalProcess("HelloWorld");
        this.createBreakpointInHelloWorld();
    }

    @Override
    protected DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    protected DebuggerSession attachVirtualMachine(RunProfileState state, ExecutionEnvironment environment, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection));
        XDebuggerManager.getInstance((Project)this.myProject).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    9.$$$reportNull$$$0(0);
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
                if (javaDebugProcess == null) {
                    9.$$$reportNull$$$0(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return debuggerSession;
    }

    protected void disableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, false);
    }

    protected void enableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, true);
    }

    private void setRendererEnabled(NodeRenderer renderer, boolean state) {
        boolean oldValue = renderer.isEnabled();
        if (oldValue != state) {
            this.myTearDownRunnables.add(() -> renderer.setEnabled(oldValue));
            renderer.setEnabled(state);
        }
    }

    protected void doWhenXSessionPausedThenResume(final ThrowableRunnable runnable) {
        final XDebugSession session = this.getDebuggerSession().getXDebugSession();
        DebuggerTestCase.assertNotNull((Object)session);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        DebuggerTestCase.this.addException(e);
                    }
                    finally {
                        SwingUtilities.invokeLater(() -> ((XDebugSession)session).resume());
                    }
                });
            }
        });
    }

    private /* synthetic */ void lambda$attachVM$2(DebuggerSession[] debuggerSession, RemoteState remoteState, RemoteConnection remoteConnection, boolean pollConnection) {
        try {
            debuggerSession[0] = this.attachVirtualMachine(remoteState, new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration()).build(), remoteConnection, pollConnection);
        }
        catch (ExecutionException e) {
            DebuggerTestCase.fail((String)e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MockConfiguration
    implements ModuleRunConfiguration {
        @NotNull
        public Module[] getModules() {
            Module[] moduleArray;
            if (DebuggerTestCase.this.myModule == null) {
                moduleArray = Module.EMPTY_ARRAY;
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = DebuggerTestCase.this.myModule;
            }
            if (moduleArray == null) {
                MockConfiguration.$$$reportNull$$$0(0);
            }
            return moduleArray;
        }

        public Icon getIcon() {
            return null;
        }

        public ConfigurationFactory getFactory() {
            return UnknownConfigurationType.getInstance();
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                MockConfiguration.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            throw new UnsupportedOperationException();
        }

        public Project getProject() {
            return null;
        }

        public RunConfiguration clone() {
            return null;
        }

        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
            if (executor == null) {
                MockConfiguration.$$$reportNull$$$0(2);
            }
            if (env == null) {
                MockConfiguration.$$$reportNull$$$0(3);
            }
            return null;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                MockConfiguration.$$$reportNull$$$0(4);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$MockConfiguration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$MockConfiguration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

