/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImpl;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LightFixtureCompletionTestCase
extends LightCodeInsightFixtureTestCase {
    protected LookupElement[] myItems;

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_1_6;
        if (lightProjectDescriptor == null) {
            LightFixtureCompletionTestCase.$$$reportNull$$$0(0);
        }
        return lightProjectDescriptor;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((StatisticsManagerImpl)StatisticsManager.getInstance()).enableStatistics(this.myFixture.getTestRootDisposable());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myItems = null;
            CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE = 3;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void configureByFile(String path) {
        this.myFixture.configureFromExistingVirtualFile(this.myFixture.copyFileToProject(path, StringUtil.getShortName((String)path, (char)'/')));
        this.complete();
    }

    protected void configureByTestName() {
        this.configureByFile("/" + this.getTestName(false) + ".java");
    }

    protected void doAntiTest() {
        this.configureByTestName();
        this.checkResultByFile(this.getTestName(false) + ".java");
        LightFixtureCompletionTestCase.assertEmpty((Object[])this.myItems);
        LightFixtureCompletionTestCase.assertNull((Object)this.getLookup());
    }

    protected void complete() {
        this.myItems = this.myFixture.completeBasic();
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void checkResultByFile(String path) {
        this.myFixture.checkResultByFile(path);
    }

    protected void selectItem(@NotNull LookupElement item, char completionChar) {
        if (item == null) {
            LightFixtureCompletionTestCase.$$$reportNull$$$0(1);
        }
        LookupImpl lookup = this.getLookup();
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar((char)completionChar)) {
            lookup.finishLookup(completionChar);
        } else {
            this.type(completionChar);
        }
    }

    protected LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
    }

    protected void assertFirstStringItems(String ... items) {
        List strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull((Object)strings);
        LightFixtureCompletionTestCase.assertOrderedEquals((Iterable)ContainerUtil.getFirstItems((List)strings, (int)items.length), (Object[])items);
    }

    protected void assertStringItems(String ... items) {
        List strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull((Object)strings);
        LightFixtureCompletionTestCase.assertOrderedEquals((Iterable)strings, (Object[])items);
    }

    protected void type(String s) {
        this.myFixture.type(s);
    }

    protected void type(char c) {
        this.myFixture.type(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/LightFixtureCompletionTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/LightFixtureCompletionTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

