/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGradleJvmName", "", "setting", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getGroupId", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "getYesNoUsage", "key", "value", "", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.gradle.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings gradleSettings2 = gradleSettings;
        Collection<GradleProjectSettings> collection = gradleSettings2.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"gradleSettings.linkedProjectsSettings");
        Collection<GradleProjectSettings> projectsSettings = collection;
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"offlineWork", (boolean)gradleSettings2.isOfflineWork()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"showSelectiveImportDialogOnInitialImport", (boolean)gradleSettings2.showSelectiveImportDialogOnInitialImport()));
        GradleSettingsService gradleSettingsService = GradleSettingsService.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleSettingsService, (String)"GradleSettingsService.getInstance(project)");
        GradleSettingsService settingsService = gradleSettingsService;
        Iterator<GradleProjectSettings> iterator = gradleSettings2.getLinkedProjectsSettings().iterator();
        while (iterator.hasNext()) {
            GradleVersion gradleVersion;
            GradleProjectSettings setting;
            GradleProjectSettings gradleProjectSettings = setting = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleProjectSettings), (String)"setting");
            String projectPath = gradleProjectSettings.getExternalProjectPath();
            usages.add(this.getYesNoUsage("isCompositeBuilds", setting.getCompositeBuild() != null));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"distributionType", (Enum)setting.getDistributionType()));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"storeProjectFilesExternally", (Enum)((Enum)setting.getStoreProjectFilesExternally())));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"disableWrapperSourceDistributionNotification", (boolean)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"createModulePerSourceSet", (boolean)setting.isResolveModulePerSourceSet()));
            StringBuilder stringBuilder = new StringBuilder().append("gradleJvm.");
            String string = this.getGradleJvmName(setting, project);
            if (string == null) {
                string = "empty";
            }
            usages.add(new UsageDescriptor(stringBuilder.append(ConvertUsagesUtil.escapeDescriptorName((String)string)).toString(), 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)setting.resolveGradleVersion(), (String)"setting.resolveGradleVersion()");
            if (gradleVersion.isSnapshot()) {
                StringBuilder stringBuilder2 = new StringBuilder().append("gradleVersion.");
                GradleVersion gradleVersion2 = gradleVersion.getBaseVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"gradleVersion.baseVersion");
                usages.add(new UsageDescriptor(stringBuilder2.append(gradleVersion2.getVersion()).append(".SNAPSHOT").toString(), 1));
            } else {
                usages.add(new UsageDescriptor("gradleVersion." + gradleVersion.getVersion(), 1));
            }
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"delegateBuildRun", (boolean)settingsService.isDelegatedBuildEnabled(projectPath)));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"preferredTestRunner", (Enum)settingsService.getTestRunner(projectPath)));
        }
        return usages;
    }

    private final String getGradleJvmName(GradleProjectSettings setting, Project project) {
        Sdk jdk;
        Sdk sdk = jdk = ExternalSystemJdkUtil.getJdk((Project)project, (String)setting.getGradleJvm());
        SdkTypeId sdkType = sdk != null ? sdk.getSdkType() : null;
        return sdkType instanceof SdkType ? ((SdkType)sdkType).suggestSdkName(null, jdk.getHomePath()) : setting.getGradleJvm();
    }

    private final UsageDescriptor getYesNoUsage(String key, boolean value) {
        return new UsageDescriptor(key + (value ? ".yes" : ".no"), 1);
    }
}

