/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DefaultGradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleRunnerConfigurable
implements Configurable {
    private JPanel myMainPanel;
    private JBCheckBox myGradleAwareMakeCheckBox;
    private ComboBox myPreferredTestRunner;
    private static final TestRunnerItem[] TEST_RUNNER_ITEMS = new TestRunnerItem[]{new TestRunnerItem(TestRunner.PLATFORM), new TestRunnerItem(TestRunner.GRADLE), new TestRunnerItem(TestRunner.CHOOSE_PER_TEST)};
    private final DefaultGradleProjectSettings mySettings;

    public GradleRunnerConfigurable(@NotNull DefaultGradleProjectSettings settings) {
        if (settings == null) {
            GradleRunnerConfigurable.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return GradleBundle.message("gradle.runner", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.project.gradle";
    }

    public void apply() throws ConfigurationException {
        boolean gradleMakeEnabled = this.myGradleAwareMakeCheckBox.isSelected();
        this.mySettings.setDelegatedBuild(gradleMakeEnabled);
        TestRunner preferredTestRunner = this.getSelectedRunner();
        this.mySettings.setTestRunner(preferredTestRunner);
    }

    public void reset() {
        TestRunnerItem item = GradleRunnerConfigurable.getItem(this.mySettings.getTestRunner());
        this.myPreferredTestRunner.setSelectedItem((Object)item);
        boolean gradleMakeEnabled = this.mySettings.isDelegatedBuild();
        this.enableGradleMake(gradleMakeEnabled);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.mySettings.isDelegatedBuild() != this.myGradleAwareMakeCheckBox.isSelected() || this.mySettings.getTestRunner() != this.getSelectedRunner();
    }

    private void createUIComponents() {
        this.myGradleAwareMakeCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.use.gradle.aware.make", new Object[0]));
        this.myGradleAwareMakeCheckBox.addActionListener(e -> this.enableGradleMake(this.myGradleAwareMakeCheckBox.isSelected()));
        this.myPreferredTestRunner = new ComboBox((Object[])GradleRunnerConfigurable.getItems());
    }

    private void enableGradleMake(boolean enable) {
        this.myGradleAwareMakeCheckBox.setSelected(enable);
    }

    private TestRunner getSelectedRunner() {
        TestRunnerItem selectedItem = (TestRunnerItem)this.myPreferredTestRunner.getSelectedItem();
        return selectedItem == null ? TestRunner.CHOOSE_PER_TEST : selectedItem.value;
    }

    private static TestRunnerItem getItem(TestRunner preferredTestRunner) {
        for (TestRunnerItem item : GradleRunnerConfigurable.getItems()) {
            if (item.value != preferredTestRunner) continue;
            return item;
        }
        return null;
    }

    private static TestRunnerItem[] getItems() {
        return TEST_RUNNER_ITEMS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/settings/GradleRunnerConfigurable", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ComboBox comboBox = this.myPreferredTestRunner;
        jPanel.add((Component)comboBox, new GridConstraints(2, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 4, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("<html>Run tests using:</html>");
        jPanel.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 5, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox = this.myGradleAwareMakeCheckBox;
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    static class TestRunnerItem {
        TestRunner value;

        TestRunnerItem(TestRunner value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestRunnerItem)) {
                return false;
            }
            TestRunnerItem item = (TestRunnerItem)o;
            return this.value == item.value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value});
        }

        public String toString() {
            return GradleBundle.message("gradle.preferred_test_runner." + (this.value == null ? "CHOOSE_PER_TEST" : this.value.name()), new Object[0]);
        }
    }
}

