/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.DefaultGradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class IdeaGradleProjectSettingsControlBuilder
implements GradleProjectSettingsControlBuilder {
    private static final long BALLOON_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    @NotNull
    private final GradleProjectSettings myInitialSettings;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private LocationSettingType myGradleHomeSettingType;
    private boolean myShowBalloonIfNecessary;
    private final ActionListener myActionListener;
    private boolean dropUseAutoImportBox;
    private boolean dropCreateEmptyContentRootDirectoriesBox;
    private boolean dropModulesGroupingOptionPanel;
    @Nullable
    private JLabel myGradleHomeLabel;
    @Nullable
    private TextFieldWithBrowseButton myGradleHomePathField;
    private boolean dropGradleHomePathComponents;
    @Nullable
    private JLabel myGradleJdkLabel;
    @Nullable
    protected ExternalSystemJdkComboBox myGradleJdkComboBox;
    @Nullable
    protected FixedSizeButton myGradleJdkSetUpButton;
    private boolean dropGradleJdkComponents;
    @Nullable
    private JBRadioButton myUseWrapperButton;
    private boolean dropUseWrapperButton;
    @Nullable
    private JBRadioButton myUseWrapperWithVerificationButton;
    @Nullable
    private JBLabel myUseWrapperVerificationLabel;
    private boolean dropCustomizableWrapperButton;
    @Nullable
    private JBRadioButton myUseLocalDistributionButton;
    private boolean dropUseLocalDistributionButton;
    @Nullable
    private JBRadioButton myUseBundledDistributionButton;
    private boolean dropUseBundledDistributionButton;
    @Nullable
    private JBCheckBox myResolveModulePerSourceSetCheckBox;
    private boolean dropResolveModulePerSourceSetCheckBox;
    @Nullable
    private JBCheckBox myResolveExternalAnnotationsCheckBox;
    private boolean dropResolveExternalAnnotationsCheckBox;
    @Nullable
    private JBCheckBox myStoreExternallyCheckBox;
    private boolean dropStoreExternallyCheckBox;
    @Nullable
    private JLabel myDelegateBuildLabel;
    @Nullable
    private ComboBox<BuildRunItem> myDelegateBuildCombobox;
    private boolean dropDelegateBuildCombobox;
    @Nullable
    private JLabel myTestRunnerLabel;
    @Nullable
    private ComboBox<TestRunnerItem> myTestRunnerCombobox;
    private boolean dropTestRunnerCombobox;
    private JPanel myDelegatePanel;
    @Nullable
    private JPanel myGradleJdkPanel;
    @NotNull
    private final Ref<Project> myProjectRef;
    @NotNull
    private final Disposable myProjectRefDisposable;

    public IdeaGradleProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
        if (initialSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(0);
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
        this.dropResolveExternalAnnotationsCheckBox = !Registry.is((String)"external.system.import.resolve.annotations", (boolean)false);
        this.myProjectRef = Ref.create();
        this.myProjectRefDisposable = () -> this.myProjectRef.set(null);
        this.myInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        this.myInitialSettings = initialSettings;
        this.myActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null) {
                    return;
                }
                boolean localDistributionEnabled = IdeaGradleProjectSettingsControlBuilder.this.myUseLocalDistributionButton != null && IdeaGradleProjectSettingsControlBuilder.this.myUseLocalDistributionButton.isSelected();
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.setEnabled(localDistributionEnabled);
                if (localDistributionEnabled) {
                    if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getText().isEmpty()) {
                        IdeaGradleProjectSettingsControlBuilder.this.deduceGradleHomeIfPossible();
                    } else if (IdeaGradleProjectSettingsControlBuilder.this.myInstallationManager.isGradleSdkHome(IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getText())) {
                        IdeaGradleProjectSettingsControlBuilder.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_CORRECT;
                    } else {
                        IdeaGradleProjectSettingsControlBuilder.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                        IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = true;
                    }
                    IdeaGradleProjectSettingsControlBuilder.this.showBalloonIfNecessary();
                } else {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        };
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleJdkComponents() {
        this.dropGradleJdkComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseWrapperButton() {
        this.dropUseWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleHomePathComponents() {
        this.dropGradleHomePathComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCustomizableWrapperButton() {
        this.dropCustomizableWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseLocalDistributionButton() {
        this.dropUseLocalDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseBundledDistributionButton() {
        this.dropUseBundledDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseAutoImportBox() {
        this.dropUseAutoImportBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCreateEmptyContentRootDirectoriesBox() {
        this.dropCreateEmptyContentRootDirectoriesBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveModulePerSourceSetCheckBox() {
        this.dropResolveModulePerSourceSetCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveExternalAnnotationsCheckBox() {
        this.dropResolveExternalAnnotationsCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropStoreExternallyCheckBox() {
        this.dropStoreExternallyCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropModulesGroupingOptionPanel() {
        this.dropModulesGroupingOptionPanel = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropDelegateBuildCombobox() {
        this.dropDelegateBuildCombobox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropTestRunnerCombobox() {
        this.dropTestRunnerCombobox = true;
        return this;
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
    }

    @Override
    @NotNull
    public GradleProjectSettings getInitialSettings() {
        GradleProjectSettings gradleProjectSettings = this.myInitialSettings;
        if (gradleProjectSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(1);
        }
        return gradleProjectSettings;
    }

    @Override
    public ExternalSystemSettingsControlCustomizer getExternalSystemSettingsControlCustomizer() {
        return new ExternalSystemSettingsControlCustomizer(this.dropUseAutoImportBox, this.dropCreateEmptyContentRootDirectoriesBox, this.dropModulesGroupingOptionPanel);
    }

    @Override
    public void createAndFillControls(PaintAwarePanel content, int indentLevel) {
        content.setPaintCallback(graphics -> this.showBalloonIfNecessary());
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"ancestor".equals(evt.getPropertyName())) {
                    return;
                }
                IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = evt.getNewValue() != null && evt.getOldValue() == null;
                if (evt.getNewValue() == null && evt.getOldValue() != null) {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        });
        if (!this.dropResolveModulePerSourceSetCheckBox) {
            this.myResolveModulePerSourceSetCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.create.module.per.sourceset", new Object[0]));
            content.add((Component)this.myResolveModulePerSourceSetCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropResolveExternalAnnotationsCheckBox) {
            this.myResolveExternalAnnotationsCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.resolve.external.annotations", new Object[0]));
            content.add((Component)this.myResolveExternalAnnotationsCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropStoreExternallyCheckBox && this.myInitialSettings.getStoreProjectFilesExternally() != ThreeState.UNSURE) {
            this.myStoreExternallyCheckBox = new JBCheckBox("Store generated project files externally");
            content.add((Component)this.myStoreExternallyCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        this.addGradleChooserComponents(content, indentLevel);
        this.addGradleHomeComponents(content, indentLevel);
        this.addGradleJdkComponents(content, indentLevel);
        this.addGradleDelegationComponents(content, indentLevel);
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
    }

    private void deduceGradleHomeIfPossible() {
        if (this.myGradleHomePathField == null) {
            return;
        }
        File gradleHome = this.myInstallationManager.getAutodetectedGradleHome();
        if (gradleHome == null) {
            new DelayedBalloonInfo(MessageType.WARNING, LocationSettingType.UNKNOWN, BALLOON_DELAY_MILLIS).run();
            return;
        }
        this.myGradleHomeSettingType = LocationSettingType.DEDUCED;
        new DelayedBalloonInfo(MessageType.INFO, LocationSettingType.DEDUCED, BALLOON_DELAY_MILLIS).run();
        this.myGradleHomePathField.setText(gradleHome.getPath());
        this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleJdkComponents(PaintAwarePanel content, int indentLevel) {
        if (!this.dropGradleJdkComponents) {
            this.myGradleJdkLabel = new JBLabel(GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            this.myGradleJdkComboBox = new ExternalSystemJdkComboBox();
            Sdk internalJdk = ExternalSystemJdkUtil.getJdk(null, (String)"#JAVA_INTERNAL");
            if (internalJdk == null || !ExternalSystemJdkUtil.isValidJdk((String)internalJdk.getHomePath())) {
                this.myGradleJdkComboBox.withoutJre();
            }
            content.add((Component)this.myGradleJdkLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)(indentLevel + 1)));
            this.myGradleJdkPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
            this.myGradleJdkPanel.setFocusable(false);
            this.myGradleJdkPanel.add((Component)this.myGradleJdkComboBox, "Center");
            this.myGradleJdkSetUpButton = new FixedSizeButton((JComponent)this.myGradleJdkComboBox);
            this.myGradleJdkSetUpButton.setToolTipText(UIBundle.message((String)"component.with.browse.button.browse.button.tooltip.text", (Object[])new Object[0]));
            DumbAwareAction.create(event -> {
                for (ActionListener listener : this.myGradleJdkSetUpButton.getActionListeners()) {
                    listener.actionPerformed(new ActionEvent(this.myGradleJdkComboBox, 1001, "action"));
                }
            }).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)this.myGradleJdkComboBox);
            if (ScreenReader.isActive()) {
                this.myGradleJdkSetUpButton.setFocusable(true);
                this.myGradleJdkSetUpButton.getAccessibleContext().setAccessibleName(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
            }
            this.myGradleJdkPanel.add((Component)this.myGradleJdkSetUpButton, "East");
            content.add((Component)this.myGradleJdkPanel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
        }
        return this;
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleChooserComponents(PaintAwarePanel content, int indentLevel) {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (!this.dropUseWrapperButton) {
            this.myUseWrapperButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
            this.myUseWrapperButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseWrapperButton);
            content.add((Component)this.myUseWrapperButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropCustomizableWrapperButton) {
            this.myUseWrapperWithVerificationButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.customizable_wrapper", new Object[0]));
            this.myUseWrapperWithVerificationButton.addActionListener(this.myActionListener);
            this.myUseWrapperVerificationLabel = new JBLabel(GradleBundle.message("gradle.settings.text.wrapper.customization.compatibility", new Object[0]));
            this.myUseWrapperVerificationLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
            this.myUseWrapperVerificationLabel.setIcon(UIUtil.getBalloonInformationIcon());
            buttonGroup.add((AbstractButton)this.myUseWrapperWithVerificationButton);
            content.add((Component)this.myUseWrapperWithVerificationButton, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add((Component)this.myUseWrapperVerificationLabel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropUseLocalDistributionButton) {
            this.myUseLocalDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.local.distribution", new Object[0]));
            this.myUseLocalDistributionButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseLocalDistributionButton);
            content.add((Component)this.myUseLocalDistributionButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropUseBundledDistributionButton) {
            this.myUseBundledDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.bundled.distribution", GradleVersion.current().getVersion()));
            this.myUseBundledDistributionButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseBundledDistributionButton);
            content.add((Component)this.myUseBundledDistributionButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        return this;
    }

    @Override
    public boolean validate(GradleProjectSettings settings) throws ConfigurationException {
        if (this.myGradleJdkComboBox != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk selectedJdk = this.myGradleJdkComboBox.getSelectedJdk();
            if (selectedJdk == null) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.undefined", new Object[0]));
            }
            String homePath = selectedJdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk((String)homePath)) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.incorrect", homePath));
            }
        }
        if (this.myGradleHomePathField == null) {
            return true;
        }
        String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected()) {
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.empty", gradleHomePath));
            }
            if (!this.myInstallationManager.isGradleSdkHome(new File(gradleHomePath))) {
                this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.incorrect", gradleHomePath));
            }
        }
        return true;
    }

    @Override
    public void apply(GradleProjectSettings settings) {
        Object testRunnerSelectedItem;
        Object delegateBuildSelectedItem;
        settings.setCompositeBuild(this.myInitialSettings.getCompositeBuild());
        if (this.myGradleHomePathField != null) {
            String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                settings.setGradleHome(null);
            } else {
                settings.setGradleHome(gradleHomePath);
                GradleUtil.storeLastUsedGradleHome(gradleHomePath);
            }
        }
        if (this.myGradleJdkComboBox != null) {
            String gradleJvm = FileUtil.toCanonicalPath((String)this.myGradleJdkComboBox.getSelectedValue());
            settings.setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            settings.setResolveModulePerSourceSet(this.myResolveModulePerSourceSetCheckBox.isSelected());
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            settings.setResolveExternalAnnotations(this.myResolveExternalAnnotationsCheckBox.isSelected());
        }
        if (this.myStoreExternallyCheckBox != null) {
            settings.setStoreProjectFilesExternally(ThreeState.fromBoolean((boolean)this.myStoreExternallyCheckBox.isSelected()));
        }
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.LOCAL);
        } else if (this.myUseWrapperButton != null && this.myUseWrapperButton.isSelected()) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (this.myUseWrapperWithVerificationButton != null && this.myUseWrapperWithVerificationButton.isSelected() || this.myUseBundledDistributionButton != null && this.myUseBundledDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.WRAPPED);
        }
        if (this.myDelegateBuildCombobox != null && (delegateBuildSelectedItem = this.myDelegateBuildCombobox.getSelectedItem()) instanceof BuildRunItem) {
            settings.setDelegatedBuild((ThreeState)ObjectUtils.notNull((Object)((BuildRunItem)delegateBuildSelectedItem).value, (Object)ThreeState.UNSURE));
        }
        if (this.myTestRunnerCombobox != null && (testRunnerSelectedItem = this.myTestRunnerCombobox.getSelectedItem()) instanceof TestRunnerItem) {
            settings.setTestRunner((TestRunner)((Object)((TestRunnerItem)testRunnerSelectedItem).value));
        }
    }

    @Override
    public boolean isModified() {
        DistributionType distributionType = this.myInitialSettings.getDistributionType();
        if (this.myUseBundledDistributionButton != null && this.myUseBundledDistributionButton.isSelected() && distributionType != DistributionType.BUNDLED) {
            return true;
        }
        if (this.myUseWrapperButton != null && this.myUseWrapperButton.isSelected() && distributionType != DistributionType.DEFAULT_WRAPPED) {
            return true;
        }
        if (this.myUseWrapperWithVerificationButton != null && this.myUseWrapperWithVerificationButton.isSelected() && distributionType != DistributionType.WRAPPED) {
            return true;
        }
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected() && distributionType != DistributionType.LOCAL) {
            return true;
        }
        if (this.myResolveModulePerSourceSetCheckBox != null && this.myResolveModulePerSourceSetCheckBox.isSelected() != this.myInitialSettings.isResolveModulePerSourceSet()) {
            return true;
        }
        if (this.myResolveExternalAnnotationsCheckBox != null && this.myResolveExternalAnnotationsCheckBox.isSelected() != this.myInitialSettings.isResolveExternalAnnotations()) {
            return true;
        }
        if (this.myStoreExternallyCheckBox != null && ThreeState.fromBoolean((boolean)this.myStoreExternallyCheckBox.isSelected()) != this.myInitialSettings.getStoreProjectFilesExternally()) {
            return true;
        }
        if (this.myDelegateBuildCombobox != null && this.myDelegateBuildCombobox.getSelectedItem() instanceof MyItem && ((MyItem)this.myDelegateBuildCombobox.getSelectedItem()).value != this.myInitialSettings.getDelegatedBuild()) {
            return true;
        }
        if (this.myTestRunnerCombobox != null && this.myTestRunnerCombobox.getSelectedItem() instanceof MyItem && ((MyItem)this.myTestRunnerCombobox.getSelectedItem()).value != this.myInitialSettings.getTestRunner()) {
            return true;
        }
        if (this.myGradleJdkComboBox != null && !StringUtil.equals((CharSequence)this.myGradleJdkComboBox.getSelectedValue(), (CharSequence)this.myInitialSettings.getGradleJvm())) {
            return true;
        }
        if (this.myGradleHomePathField == null) {
            return false;
        }
        String gradleHome = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHome)) {
            return !StringUtil.isEmpty((String)this.myInitialSettings.getGradleHome());
        }
        return !gradleHome.equals(this.myInitialSettings.getGradleHome());
    }

    @Override
    public void reset(@Nullable Project project, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        this.reset(project, settings, isDefaultModuleCreation, null);
    }

    @Override
    public void reset(@Nullable Project project, GradleProjectSettings settings, boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.updateProjectRef(project, wizardContext);
        String gradleHome = settings.getGradleHome();
        if (this.myGradleHomePathField != null) {
            this.myGradleHomePathField.setText(gradleHome == null ? "" : gradleHome);
            this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings.isResolveModulePerSourceSet());
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            this.myResolveExternalAnnotationsCheckBox.setSelected(settings.isResolveExternalAnnotations());
        }
        if (this.myStoreExternallyCheckBox != null) {
            this.myStoreExternallyCheckBox.setSelected(settings.getStoreProjectFilesExternally() == ThreeState.YES);
        }
        this.resetGradleJdkComboBox(project, settings, wizardContext);
        this.resetWrapperControls(settings.getExternalProjectPath(), settings, isDefaultModuleCreation);
        this.resetGradleDelegationControls(wizardContext);
        if (this.myUseLocalDistributionButton != null && !this.myUseLocalDistributionButton.isSelected()) {
            this.myGradleHomePathField.setEnabled(false);
            return;
        }
        if (StringUtil.isEmpty((String)gradleHome)) {
            this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
            this.deduceGradleHomeIfPossible();
        } else {
            this.myGradleHomeSettingType = this.myInstallationManager.isGradleSdkHome(new File(gradleHome)) ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT;
            this.myAlarm.cancelAllRequests();
            if (this.myGradleHomeSettingType == LocationSettingType.EXPLICIT_INCORRECT && settings.getDistributionType() == DistributionType.LOCAL) {
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
            }
        }
    }

    @Override
    public void update(String linkedProjectPath, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        this.resetWrapperControls(linkedProjectPath, settings, isDefaultModuleCreation);
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings.isResolveModulePerSourceSet());
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            this.myResolveExternalAnnotationsCheckBox.setSelected(settings.isResolveExternalAnnotations());
        }
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleHomeComponents(PaintAwarePanel content, int indentLevel) {
        if (this.dropGradleHomePathComponents) {
            return this;
        }
        this.myGradleHomeLabel = new JBLabel(GradleBundle.message("gradle.settings.text.home.path", new Object[0]));
        this.myGradleHomePathField = new TextFieldWithBrowseButton();
        this.myGradleHomePathField.addBrowseFolderListener("", GradleBundle.message("gradle.settings.text.home.path", new Object[0]), null, GradleUtil.getGradleHomeFileChooserDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        content.add((Component)this.myGradleHomeLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        content.add((Component)this.myGradleHomePathField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
        return this;
    }

    protected void resetGradleJdkComboBox(@Nullable Project project, GradleProjectSettings settings, @Nullable WizardContext wizardContext) {
        if (this.myGradleJdkComboBox == null) {
            return;
        }
        String gradleJvm = settings.getGradleJvm();
        this.myGradleJdkComboBox.setProject(project);
        this.myGradleJdkComboBox.setProjectJdk(null);
        Sdk projectJdk = wizardContext != null ? wizardContext.getProjectJdk() : null;
        String sdkItem = (String)ObjectUtils.nullizeByCondition((Object)gradleJvm, s -> projectJdk == null && project == null && StringUtil.equals((CharSequence)"#USE_PROJECT_JDK", (CharSequence)s) || StringUtil.isEmpty((String)s));
        this.myGradleJdkComboBox.refreshData(sdkItem, projectJdk);
        if (this.myGradleJdkSetUpButton != null) {
            ProjectSdksModel sdksModel = new ProjectSdksModel();
            this.myGradleJdkComboBox.setSetupButton((JButton)this.myGradleJdkSetUpButton, sdksModel, null, JavaSdkType.class::isInstance);
        }
    }

    private void resetWrapperControls(String linkedProjectPath, @NotNull GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        if (settings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(2);
        }
        if (isDefaultModuleCreation) {
            JComponent[] toRemove;
            for (JComponent component : toRemove = new JComponent[]{this.myUseWrapperWithVerificationButton, this.myUseWrapperVerificationLabel}) {
                Container parent;
                if (component == null || (parent = component.getParent()) == null) continue;
                parent.remove(component);
            }
            this.myUseWrapperWithVerificationButton = null;
            this.myUseWrapperVerificationLabel = null;
        }
        if (StringUtil.isEmpty((String)linkedProjectPath) && !isDefaultModuleCreation) {
            if (this.myUseLocalDistributionButton != null) {
                this.myUseLocalDistributionButton.setSelected(true);
            }
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(true);
            }
            return;
        }
        boolean isGradleDefaultWrapperFilesExist = GradleUtil.isGradleDefaultWrapperFilesExist(linkedProjectPath);
        if (this.myUseWrapperButton != null && (isGradleDefaultWrapperFilesExist || isDefaultModuleCreation)) {
            this.myUseWrapperButton.setEnabled(true);
            this.myUseWrapperButton.setSelected(true);
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(false);
            }
            this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
        } else {
            if (this.myUseWrapperButton != null) {
                this.myUseWrapperButton.setEnabled(false);
                this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.not_configured", new Object[0]));
            }
            if (this.myUseLocalDistributionButton != null) {
                this.myUseLocalDistributionButton.setSelected(true);
            }
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(true);
            }
        }
        if (settings.getDistributionType() == null) {
            return;
        }
        switch (settings.getDistributionType()) {
            case LOCAL: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(true);
                }
                if (this.myUseLocalDistributionButton == null) break;
                this.myUseLocalDistributionButton.setSelected(true);
                break;
            }
            case DEFAULT_WRAPPED: {
                if (!isGradleDefaultWrapperFilesExist) break;
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseWrapperButton == null) break;
                this.myUseWrapperButton.setSelected(true);
                this.myUseWrapperButton.setEnabled(true);
                break;
            }
            case WRAPPED: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseWrapperWithVerificationButton == null) break;
                this.myUseWrapperWithVerificationButton.setSelected(true);
                break;
            }
            case BUNDLED: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseBundledDistributionButton == null) break;
                this.myUseBundledDistributionButton.setSelected(true);
            }
        }
    }

    private void addGradleDelegationComponents(PaintAwarePanel content, int indentLevel) {
        if (this.dropDelegateBuildCombobox && this.dropTestRunnerCombobox) {
            return;
        }
        this.myDelegatePanel = new JPanel(new GridBagLayout());
        String title = GradleBundle.message("gradle.settings.text.delegate.panel.title", new Object[0]);
        this.myDelegatePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)JBUI.insetsTop((int)3)));
        content.add((Component)this.myDelegatePanel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1)));
        int labelLevel = indentLevel + 1;
        if (!this.dropDelegateBuildCombobox) {
            Object[] states = (BuildRunItem[])StreamEx.of((Object[])ThreeState.values()).map(x$0 -> new BuildRunItem((ThreeState)x$0)).toArray(BuildRunItem[]::new);
            this.myDelegateBuildCombobox = new ComboBox(states);
            this.myDelegateBuildCombobox.setRenderer(new MyItemCellRenderer());
            this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
            this.myDelegateBuildLabel = new JBLabel(GradleBundle.message("gradle.settings.text.delegate.buildRun", new Object[0]));
            this.myDelegatePanel.add((Component)this.myDelegateBuildLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(labelLevel));
            this.myDelegatePanel.add((Component)this.myDelegateBuildCombobox);
        }
        if (!this.dropTestRunnerCombobox) {
            Object[] testRunners = (TestRunnerItem[])StreamEx.of((Object[])TestRunner.values()).append((Object)((TestRunner)null)).map(x$0 -> new TestRunnerItem((TestRunner)((Object)x$0))).toArray(TestRunnerItem[]::new);
            this.myTestRunnerCombobox = new ComboBox(testRunners);
            this.myTestRunnerCombobox.setRenderer(new MyItemCellRenderer());
            this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
            this.myTestRunnerLabel = new JBLabel(GradleBundle.message("gradle.settings.text.delegate.testRunner", new Object[0]));
            this.myDelegatePanel.add((Component)this.myTestRunnerLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(labelLevel));
            this.myDelegatePanel.add((Component)this.myTestRunnerCombobox);
            this.myDelegatePanel.add(Box.createGlue(), ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
    }

    private void resetGradleDelegationControls(@Nullable WizardContext wizardContext) {
        if (wizardContext != null) {
            this.dropTestRunnerCombobox();
            this.dropDelegateBuildCombobox();
            if (this.myDelegatePanel != null) {
                Container parent = this.myDelegatePanel.getParent();
                if (parent != null) {
                    parent.remove(this.myDelegatePanel);
                }
                this.myDelegatePanel = null;
                this.myDelegateBuildCombobox = null;
                this.myTestRunnerCombobox = null;
            }
            return;
        }
        if (this.myDelegateBuildCombobox != null) {
            this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
        }
        if (this.myTestRunnerCombobox != null) {
            this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
        }
    }

    @NotNull
    private static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)0, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
        if (gridBag == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(3);
        }
        return gridBag;
    }

    void showBalloonIfNecessary() {
        if (!this.myShowBalloonIfNecessary || this.myGradleHomePathField != null && !this.myGradleHomePathField.isEnabled()) {
            return;
        }
        this.myShowBalloonIfNecessary = false;
        MessageType messageType = null;
        switch (this.myGradleHomeSettingType) {
            case DEDUCED: {
                messageType = MessageType.INFO;
                break;
            }
            case EXPLICIT_INCORRECT: 
            case UNKNOWN: {
                messageType = MessageType.ERROR;
                break;
            }
        }
        if (messageType != null) {
            new DelayedBalloonInfo(messageType, this.myGradleHomeSettingType, BALLOON_DELAY_MILLIS).run();
        }
    }

    private void updateProjectRef(@Nullable Project project, @Nullable WizardContext wizardContext) {
        if (wizardContext != null && wizardContext.getProject() != null) {
            project = wizardContext.getProject();
        }
        if (project != null && project != this.myProjectRef.get() && Disposer.findRegisteredObject((Disposable)project, (Disposable)this.myProjectRefDisposable) == null) {
            Disposer.register((Disposable)project, (Disposable)this.myProjectRefDisposable);
        }
        this.myProjectRef.set((Object)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetWrapperControls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TestRunnerItem
    extends MyItem<TestRunner> {
        private TestRunnerItem(TestRunner value) {
            super((Object)value);
        }

        @Override
        protected String getText() {
            return this.getText((TestRunner)((Object)this.value));
        }

        @Override
        protected String getComment() {
            if (this.value != null && !IdeaGradleProjectSettingsControlBuilder.this.myProjectRef.isNull()) {
                return null;
            }
            TestRunner defaultRunner = IdeaGradleProjectSettingsControlBuilder.this.myProjectRef.isNull() ? null : DefaultGradleProjectSettings.getInstance((Project)IdeaGradleProjectSettingsControlBuilder.this.myProjectRef.get()).getTestRunner();
            return this.getText(defaultRunner);
        }

        @NotNull
        private String getText(@Nullable TestRunner runner) {
            if (runner == TestRunner.PLATFORM) {
                String string = ApplicationNamesInfo.getInstance().getFullProductName();
                if (string == null) {
                    TestRunnerItem.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (runner == TestRunner.GRADLE) {
                if ("Gradle" == null) {
                    TestRunnerItem.$$$reportNull$$$0(1);
                }
                return "Gradle";
            }
            if (runner == TestRunner.CHOOSE_PER_TEST) {
                String string = GradleBundle.message("gradle.preferred_test_runner.CHOOSE_PER_TEST", new Object[0]);
                if (string == null) {
                    TestRunnerItem.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = GradleBundle.message("gradle.settings.text.default", new Object[0]);
            if (string == null) {
                TestRunnerItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$TestRunnerItem", "getText"));
        }
    }

    private class BuildRunItem
    extends MyItem<ThreeState> {
        private BuildRunItem(ThreeState value) {
            super(value);
        }

        @Override
        protected String getText() {
            return this.getText((ThreeState)this.value);
        }

        @Override
        protected String getComment() {
            if (this.value != ThreeState.UNSURE) {
                return null;
            }
            ThreeState defaultDelegationOption = IdeaGradleProjectSettingsControlBuilder.this.myProjectRef.isNull() ? null : ThreeState.fromBoolean((boolean)DefaultGradleProjectSettings.getInstance((Project)IdeaGradleProjectSettingsControlBuilder.this.myProjectRef.get()).isDelegatedBuild());
            return this.getText(defaultDelegationOption);
        }

        @NotNull
        private String getText(@Nullable ThreeState state) {
            if (state == ThreeState.NO) {
                String string = ApplicationNamesInfo.getInstance().getFullProductName();
                if (string == null) {
                    BuildRunItem.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (state == ThreeState.YES) {
                if ("Gradle" == null) {
                    BuildRunItem.$$$reportNull$$$0(1);
                }
                return "Gradle";
            }
            String string = GradleBundle.message("gradle.settings.text.default", new Object[0]);
            if (string == null) {
                BuildRunItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$BuildRunItem", "getText"));
        }
    }

    private static abstract class MyItem<T> {
        @Nullable
        protected final T value;

        private MyItem(@Nullable T value) {
            this.value = value;
        }

        protected abstract String getText();

        protected abstract String getComment();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyItem)) {
                return false;
            }
            MyItem item = (MyItem)o;
            return Objects.equals(this.value, item.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class MyItemCellRenderer<T>
    extends ColoredListCellRenderer<MyItem<T>> {
        private MyItemCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MyItem<T>> list, MyItem<T> value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyItemCellRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
            ending.addText(value.getText(), MyItemCellRenderer.getTextAttributes(selected));
            if (value.getComment() != null) {
                SimpleTextAttributes commentAttributes = MyItemCellRenderer.getCommentAttributes(selected);
                ending.addComment(value.getComment(), commentAttributes);
            }
            ending.getAppearance().customize((SimpleColoredComponent)this);
        }

        @NotNull
        private static SimpleTextAttributes getTextAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = selected && (!SystemInfo.isWinVistaOrNewer || !UIManager.getLookAndFeel().getName().contains("Windows")) ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        @NotNull
        private static SimpleTextAttributes getCommentAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DelayedBalloonInfo
    implements Runnable {
        private final MessageType myMessageType;
        private final String myText;
        private final long myTriggerTime;

        DelayedBalloonInfo(@NotNull MessageType messageType, LocationSettingType settingType, long delayMillis) {
            if (messageType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(0);
            }
            if (settingType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(1);
            }
            this.myMessageType = messageType;
            this.myText = settingType.getDescription(GradleConstants.SYSTEM_ID);
            this.myTriggerTime = System.currentTimeMillis() + delayMillis;
        }

        @Override
        public void run() {
            long diff = this.myTriggerTime - System.currentTimeMillis();
            if (diff > 0L) {
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.addRequest((Runnable)this, diff);
                return;
            }
            if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null || !IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.isShowing()) {
                return;
            }
            ExternalSystemUiUtil.showBalloon((JComponent)IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField, (MessageType)this.myMessageType, (String)this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DelayedBalloonInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

