/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "intellij.gradle.common"})
public final class GradleRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, Object> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkParameterIsNotNull(cfg, (String)"cfg");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = ((GradleRunConfiguration)runConfiguration).getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemTaskExecutionSettings, (String)"runConfiguration.settings");
        ExternalSystemTaskExecutionSettings settings = externalSystemTaskExecutionSettings;
        ObjectUtils.consumeIfCast((Object)cfg.get("projectPath"), String.class, (Consumer)new Consumer<T>(settings){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;

            public final void consume(String it) {
                this.$settings.setExternalProjectPath(it);
            }
            {
                this.$settings = externalSystemTaskExecutionSettings;
            }
        });
        ObjectUtils.consumeIfCast((Object)cfg.get("taskNames"), List.class, (Consumer)new Consumer<T>(settings){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;

            public final void consume(List<?> it) {
                List<?> list = it;
                if (list == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                this.$settings.setTaskNames(list);
            }
            {
                this.$settings = externalSystemTaskExecutionSettings;
            }
        });
        ObjectUtils.consumeIfCast((Object)cfg.get("envs"), Map.class, (Consumer)new Consumer<T>(settings){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;

            public final void consume(Map<?, ?> it) {
                Map<?, ?> map = it;
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                this.$settings.setEnv(map);
            }
            {
                this.$settings = externalSystemTaskExecutionSettings;
            }
        });
        ObjectUtils.consumeIfCast((Object)cfg.get("jvmArgs"), String.class, (Consumer)new Consumer<T>(settings){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;

            public final void consume(String it) {
                this.$settings.setVmOptions(it);
            }
            {
                this.$settings = externalSystemTaskExecutionSettings;
            }
        });
        ObjectUtils.consumeIfCast((Object)cfg.get("scriptParameters"), String.class, (Consumer)new Consumer<T>(settings){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;

            public final void consume(String it) {
                this.$settings.setScriptParameters(it);
            }
            {
                this.$settings = externalSystemTaskExecutionSettings;
            }
        });
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"gradle", (Object)typeName);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GradleExternalTaskConfigurationType gradleExternalTaskConfigurationType = GradleExternalTaskConfigurationType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleExternalTaskConfigurationType), (String)"GradleExternalTaskConfigurationType.getInstance()");
        ConfigurationFactory configurationFactory = gradleExternalTaskConfigurationType.getFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"GradleExternalTaskConfig\u2026ype.getInstance().factory");
        return configurationFactory;
    }
}

