/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.preferences.MavenPreferences;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.ArtifactDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.DialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.RepositoryManagerController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.SearchMavenDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class LibraryDialogController
extends AbstractFxmlWindowController {
    @FXML
    private ListView<DialogListItem> libraryListView;
    @FXML
    private Button manageButton;
    private final DocumentWindowController documentWindowController;
    private final EditorController editorController;
    private final UserLibrary userLibrary;
    private final Window owner;
    private ObservableList<DialogListItem> listItems;

    public LibraryDialogController(EditorController editorController, DocumentWindowController documentWindowController, Window owner) {
        super(LibraryPanelController.class.getResource("LibraryDialog.fxml"), I18N.getBundle(), owner);
        this.documentWindowController = documentWindowController;
        this.owner = owner;
        this.editorController = editorController;
        this.userLibrary = (UserLibrary)editorController.getLibrary();
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner(this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        super.getStage().setTitle(I18N.getString("library.dialog.title"));
        this.loadLibraryList();
    }

    void loadLibraryList() {
        if (this.listItems == null) {
            this.listItems = FXCollections.observableArrayList();
        }
        this.listItems.clear();
        this.libraryListView.setItems(this.listItems);
        this.libraryListView.setCellFactory(param -> new LibraryDialogListCell());
        Path folder = Paths.get(this.userLibrary.getPath(), new String[0]);
        if (folder != null && folder.toFile().exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                for (Path entry : stream) {
                    if (!LibraryDialogController.isJarPath(entry) && !LibraryDialogController.isFxmlPath(entry)) continue;
                    this.listItems.add((Object)new LibraryDialogListItem(this, entry));
                }
            }
            catch (IOException x) {
                Logger.getLogger(LibraryDialogController.class.getName()).log(Level.SEVERE, "Error while getting a new directory stream.", x);
            }
        }
        this.listItems.addAll((Collection)PreferencesController.getSingleton().getMavenPreferences().getArtifactsCoordinates().stream().map(c -> new ArtifactDialogListItem(this, (String)c)).collect(Collectors.toList()));
    }

    private static boolean isJarPath(Path path) {
        String pathString = path.toString().toLowerCase(Locale.ROOT);
        return pathString.endsWith(".jar");
    }

    private static boolean isFxmlPath(Path path) {
        String pathString = path.toString().toLowerCase(Locale.ROOT);
        return pathString.endsWith(".fxml");
    }

    @FXML
    private void close() {
        this.libraryListView.getItems().clear();
        this.closeWindow();
    }

    @FXML
    private void manage() {
        RepositoryManagerController repositoryDialogController = new RepositoryManagerController(this.editorController, this.documentWindowController, (Window)this.getStage());
        repositoryDialogController.openWindow();
    }

    @FXML
    private void addJar() {
        this.documentWindowController.onImportJarFxml((Window)this.getStage());
        this.loadLibraryList();
    }

    @FXML
    private void addRelease() {
        final SearchMavenDialogController mavenDialogController = new SearchMavenDialogController(this.editorController, this.documentWindowController, (Window)this.getStage());
        mavenDialogController.openWindow();
        mavenDialogController.getStage().showingProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (!mavenDialogController.getStage().isShowing()) {
                    LibraryDialogController.this.loadLibraryList();
                    mavenDialogController.getStage().showingProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    @FXML
    private void addManually() {
        final MavenDialogController mavenDialogController = new MavenDialogController(this.editorController, this.documentWindowController, (Window)this.getStage());
        mavenDialogController.openWindow();
        mavenDialogController.getStage().showingProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (!mavenDialogController.getStage().isShowing()) {
                    LibraryDialogController.this.loadLibraryList();
                    mavenDialogController.getStage().showingProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void processJarFXMLDelete(DialogListItem dialogListItem) {
        if (dialogListItem instanceof LibraryDialogListItem && LibraryDialogController.isFxmlPath(((LibraryDialogListItem)dialogListItem).getFilePath())) {
            this.deleteFile(dialogListItem);
        } else {
            this.userLibrary.stopWatching();
            this.deleteFile(dialogListItem);
            this.userLibrary.startWatching();
        }
    }

    private void deleteFile(DialogListItem dialogListItem) {
        try {
            if (dialogListItem instanceof LibraryDialogListItem) {
                LibraryDialogListItem item = (LibraryDialogListItem)dialogListItem;
                if (Files.exists(item.getFilePath(), new LinkOption[0])) {
                    Files.delete(item.getFilePath());
                    this.listItems.remove((Object)item);
                }
            } else if (dialogListItem instanceof ArtifactDialogListItem) {
                PreferencesController.getSingleton().removeArtifact(((ArtifactDialogListItem)dialogListItem).getCoordinates());
                this.listItems.remove((Object)dialogListItem);
            }
        }
        catch (IOException x) {
            Logger.getLogger(LibraryDialogController.class.getName()).log(Level.SEVERE, "Error while deleting the file.", x);
        }
        this.loadLibraryList();
    }

    public void processJarFXMLEdit(DialogListItem dialogListItem) {
        if (dialogListItem instanceof LibraryDialogListItem) {
            LibraryDialogListItem item = (LibraryDialogListItem)dialogListItem;
            if (Files.exists(item.getFilePath(), new LinkOption[0])) {
                if (LibraryDialogController.isJarPath(item.getFilePath())) {
                    ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(this.editorController), Arrays.asList(item.getFilePath().toFile()), (Window)this.getStage());
                    iwc.setToolStylesheet(this.editorController.getToolStylesheet());
                    AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
                    if (userChoice == AbstractModalDialog.ButtonID.OK) {
                        this.logInfoMessage("log.user.maven.updated", item);
                    }
                } else {
                    if (SceneBuilderApp.getSingleton().lookupUnusedDocumentWindowController() != null) {
                        this.closeWindow();
                    }
                    SceneBuilderApp.getSingleton().performOpenRecent(this.documentWindowController, item.getFilePath().toFile());
                }
            }
        } else if (dialogListItem instanceof ArtifactDialogListItem) {
            MavenPreferences mavenPreferences = PreferencesController.getSingleton().getMavenPreferences();
            MavenArtifact mavenArtifact = mavenPreferences.getRecordArtifact(((ArtifactDialogListItem)dialogListItem).getCoordinates()).getMavenArtifact();
            List files = mavenPreferences.getArtifactFileWithDependencies(mavenArtifact);
            List filter = mavenPreferences.getArtifactFilter(mavenArtifact);
            ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(this.editorController), files, (Window)this.getStage(), false, filter);
            iwc.setToolStylesheet(this.editorController.getToolStylesheet());
            AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
            if (userChoice == AbstractModalDialog.ButtonID.OK) {
                mavenArtifact.setFilter(iwc.getNewExcludedItems());
                this.updatePreferences(mavenArtifact);
                this.logInfoMessage("log.user.maven.updated", mavenArtifact.getCoordinates());
            }
        }
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }

    private void updatePreferences(MavenArtifact mavenArtifact) {
        if (mavenArtifact == null) {
            return;
        }
        this.userLibrary.stopWatching();
        PreferencesRecordArtifact recordArtifact = PreferencesController.getSingleton().getRecordArtifact(mavenArtifact);
        recordArtifact.writeToJavaPreferences();
        this.userLibrary.startWatching();
    }
}

