/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalLineComparator;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalSegment;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;

class VerticalLineIndex {
    private static final VerticalLineComparator comparator = new VerticalLineComparator();
    private final List<VerticalSegment> lines = new ArrayList<VerticalSegment>();
    private boolean sorted;

    VerticalLineIndex() {
    }

    public void addLine(VerticalSegment s) {
        this.lines.add(s);
        this.sorted = false;
    }

    public void clear() {
        this.lines.clear();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public List<VerticalSegment> matchWest(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        return this.matchX(boundsInScene.getMinX(), threshold);
    }

    public List<VerticalSegment> matchEast(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        return this.matchX(boundsInScene.getMaxX(), threshold);
    }

    public List<VerticalSegment> matchCenter(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        double minX = boundsInScene.getMinX();
        double maxX = boundsInScene.getMaxX();
        return this.matchX((minX + maxX) / 2.0, threshold);
    }

    private List<VerticalSegment> matchX(double targetX, double threshold) {
        assert (threshold >= 0.0);
        if (!this.sorted) {
            Collections.sort(this.lines, comparator);
        }
        double bestDelta = Double.MAX_VALUE;
        ArrayList<VerticalSegment> result = new ArrayList<VerticalSegment>();
        for (VerticalSegment l : this.lines) {
            double delta = Math.abs(l.getX1() - targetX);
            if (!(delta < threshold)) continue;
            if (MathUtils.equals(delta, bestDelta)) {
                result.add(l);
                continue;
            }
            if (!(delta < bestDelta)) continue;
            bestDelta = delta;
            result.clear();
            result.add(l);
        }
        return result;
    }
}

