/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalLineComparator;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalSegment;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;

class HorizontalLineIndex {
    private static final HorizontalLineComparator comparator = new HorizontalLineComparator();
    private final List<HorizontalSegment> lines = new ArrayList<HorizontalSegment>();
    private boolean sorted;

    HorizontalLineIndex() {
    }

    public void addLine(HorizontalSegment s) {
        this.lines.add(s);
        this.sorted = false;
    }

    public void clear() {
        this.lines.clear();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public List<HorizontalSegment> matchNorth(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        return this.matchY(boundsInScene.getMinY(), threshold);
    }

    public List<HorizontalSegment> matchSouth(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        return this.matchY(boundsInScene.getMaxY(), threshold);
    }

    public List<HorizontalSegment> matchCenter(Bounds boundsInScene, double threshold) {
        assert (!boundsInScene.isEmpty());
        double minY = boundsInScene.getMinY();
        double maxY = boundsInScene.getMaxY();
        return this.matchY((minY + maxY) / 2.0, threshold);
    }

    private List<HorizontalSegment> matchY(double targetY, double threshold) {
        assert (threshold >= 0.0);
        if (!this.sorted) {
            Collections.sort(this.lines, comparator);
        }
        double bestDelta = Double.MAX_VALUE;
        ArrayList<HorizontalSegment> result = new ArrayList<HorizontalSegment>();
        for (HorizontalSegment l : this.lines) {
            double delta = Math.abs(l.getY1() - targetY);
            if (!(delta < threshold)) continue;
            if (MathUtils.equals(delta, bestDelta)) {
                result.add(l);
                continue;
            }
            if (!(delta < bestDelta)) continue;
            bestDelta = delta;
            result.clear();
            result.add(l);
        }
        return result;
    }
}

