/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class WrapInTabPaneJob
extends AbstractWrapInJob {
    public WrapInTabPaneJob(EditorController editorController) {
        super(editorController);
        this.newContainerClass = TabPane.class;
    }

    @Override
    protected boolean canWrapIn() {
        boolean result;
        if (super.canWrapIn()) {
            Selection selection = this.getEditorController().getSelection();
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            result = osg.getItems().size() == 1;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    protected List<Job> wrapChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingSubComponent());
        PropertyName newContainerPropertyName = newContainerMask.getSubComponentPropertyName();
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(this.newContainer.getFxomDocument(), newContainerPropertyName);
        FXOMInstance tabContainer = this.makeNewContainerInstance(Tab.class);
        DesignHierarchyMask tabContainerMask = new DesignHierarchyMask(tabContainer);
        assert (tabContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
        PropertyName tabContainerPropertyName = new PropertyName("content");
        FXOMPropertyC tabContainerProperty = new FXOMPropertyC(tabContainer.getFxomDocument(), tabContainerPropertyName);
        AddPropertyValueJob addTabValueJob = new AddPropertyValueJob(tabContainer, newContainerProperty, -1, this.getEditorController());
        jobs.add(addTabValueJob);
        assert (children.size() == 1);
        jobs.addAll(this.modifyChildrenJobs(children));
        List<Job> addChildrenJobs = this.addChildrenJobs(tabContainerProperty, children);
        jobs.addAll(addChildrenJobs);
        assert (tabContainerProperty.getParentInstance() == null);
        AddPropertyJob addTabContainerPropertyJob = new AddPropertyJob(tabContainerProperty, tabContainer, -1, this.getEditorController());
        jobs.add(addTabContainerPropertyJob);
        assert (newContainerProperty.getParentInstance() == null);
        AddPropertyJob addNewContainerPropertyJob = new AddPropertyJob(newContainerProperty, this.newContainer, -1, this.getEditorController());
        jobs.add(addNewContainerPropertyJob);
        return jobs;
    }
}

