/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;

public class MoveCellContentJob
extends Job {
    private static final IntegerPropertyMetadata columnIndexMeta = new IntegerPropertyMetadata(new PropertyName("columnIndex", GridPane.class), true, 0, InspectorPath.UNUSED);
    private static final IntegerPropertyMetadata rowIndexMeta = new IntegerPropertyMetadata(new PropertyName("rowIndex", GridPane.class), true, 0, InspectorPath.UNUSED);
    private final FXOMInstance fxomObject;
    private final int columnIndexDelta;
    private final int rowIndexDelta;
    private int oldColumnIndex = -1;
    private int oldRowIndex = -1;

    public MoveCellContentJob(FXOMInstance fxomObject, int columnIndexDelta, int rowIndexDelta, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        this.fxomObject = fxomObject;
        this.columnIndexDelta = columnIndexDelta;
        this.rowIndexDelta = rowIndexDelta;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        this.oldColumnIndex = (Integer)columnIndexMeta.getValue(this.fxomObject);
        this.oldRowIndex = (Integer)rowIndexMeta.getValue(this.fxomObject);
        assert (this.oldColumnIndex + this.columnIndexDelta >= 0);
        assert (this.oldRowIndex + this.rowIndexDelta >= 0);
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        columnIndexMeta.setValue(this.fxomObject, this.oldColumnIndex);
        rowIndexMeta.setValue(this.fxomObject, this.oldRowIndex);
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        columnIndexMeta.setValue(this.fxomObject, this.oldColumnIndex + this.columnIndexDelta);
        rowIndexMeta.setValue(this.fxomObject, this.oldRowIndex + this.rowIndexDelta);
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

