/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PrunePropertiesJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UsePredefinedSizeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.SetFxomRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;

public class SetDocumentRootJob
extends BatchSelectionJob {
    private final FXOMObject newRoot;
    private final boolean usePredefinedSize;
    private final String description;

    public SetDocumentRootJob(FXOMObject newRoot, boolean usePredefinedSize, String description, EditorController editorController) {
        super(editorController);
        assert (editorController.getFxomDocument() != null);
        assert (newRoot == null || newRoot.getFxomDocument() == editorController.getFxomDocument());
        assert (description != null);
        this.newRoot = newRoot;
        this.usePredefinedSize = usePredefinedSize;
        this.description = description;
    }

    public SetDocumentRootJob(FXOMObject newRoot, EditorController editorController) {
        this(newRoot, false, SetDocumentRootJob.class.getSimpleName(), editorController);
    }

    public FXOMObject getNewRoot() {
        return this.newRoot;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.newRoot != this.getEditorController().getFxomDocument().getFxomRoot()) {
            DesignHierarchyMask mask;
            if (this.newRoot != null) {
                result.add(new PrunePropertiesJob(this.newRoot, null, this.getEditorController()));
            }
            result.add(new SetFxomRootJob(this.newRoot, this.getEditorController()));
            if (this.newRoot != null && this.usePredefinedSize && (mask = new DesignHierarchyMask(this.newRoot)).needResizeWhenTopElement()) {
                result.add(new UsePredefinedSizeJob(this.getEditorController(), EditorController.Size.SIZE_DEFAULT, this.newRoot));
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.description;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        if (this.newRoot == null) {
            return null;
        }
        ArrayList<FXOMObject> newObjects = new ArrayList<FXOMObject>();
        newObjects.add(this.newRoot);
        return new ObjectSelectionGroup(newObjects, this.newRoot, null);
    }
}

