/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import java.util.ArrayList;
import java.util.List;

public class SendToBackJob
extends InlineDocumentJob {
    public SendToBackJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        Selection selection = this.getEditorController().getSelection();
        if (!(selection.getGroup() instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        for (FXOMObject item : osg.getSortedItems()) {
            FXOMObject previousSlibing = item.getPreviousSlibing();
            if (previousSlibing != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        assert (this.isExecutable());
        ArrayList<Job> result = new ArrayList<Job>();
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        List<FXOMObject> candidates = osg.getSortedItems();
        for (int i = candidates.size() - 1; i >= 0; --i) {
            FXOMPropertyC parentProperty;
            FXOMObject beforeChild;
            ReIndexObjectJob subJob;
            FXOMObject candidate = candidates.get(i);
            FXOMObject previousSlibing = candidate.getPreviousSlibing();
            if (previousSlibing == null || !(subJob = new ReIndexObjectJob(candidate, beforeChild = (parentProperty = candidate.getParentProperty()).getValues().get(0), this.getEditorController())).isExecutable()) continue;
            subJob.execute();
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        switch (this.getSubJobs().size()) {
            case 0: {
                result = "Unexecutable Send To Back";
                break;
            }
            case 1: {
                result = this.getSubJobs().get(0).getDescription();
                break;
            }
            default: {
                result = this.makeMultipleSelectionDescription();
            }
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Send To Back ");
        result.append(this.getSubJobs().size());
        result.append(" Objects");
        return result.toString();
    }
}

