/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Printer {
    private static final String DEFAULT_INDENTATION_UNIT = "    ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Appendable out;
    private final int maxBlankLines;
    private String indent;
    private final String indentUnit;
    private int blankLineCountIncludingCurrent = 0;
    private boolean withholdIndentOnce = false;
    private int length = 0;

    public Printer(@NotNull Appendable out) {
        this(out, Integer.MAX_VALUE);
    }

    public Printer(@NotNull Appendable out, @NotNull String indentUnit) {
        this(out, Integer.MAX_VALUE, indentUnit);
    }

    public Printer(@NotNull Appendable out, int maxBlankLines) {
        this(out, maxBlankLines, DEFAULT_INDENTATION_UNIT);
    }

    public Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit) {
        this(out, maxBlankLines, indentUnit, "");
    }

    private Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit, @NotNull String indent) {
        this.out = out;
        this.maxBlankLines = maxBlankLines;
        this.indentUnit = indentUnit;
        this.indent = indent;
    }

    public Printer(@NotNull Appendable out, @NotNull Printer parent) {
        this(out, parent.maxBlankLines, parent.indentUnit, parent.indent);
    }

    private void append(Object o) {
        try {
            String string = o.toString();
            this.out.append(string);
            this.length += string.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public Printer println(Object ... objects) {
        this.print(objects);
        this.printLineSeparator();
        return this;
    }

    private void printLineSeparator() {
        if (this.blankLineCountIncludingCurrent <= this.maxBlankLines) {
            ++this.blankLineCountIncludingCurrent;
            this.append(LINE_SEPARATOR);
        }
    }

    @NotNull
    public Printer print(Object ... objects) {
        if (this.withholdIndentOnce) {
            this.withholdIndentOnce = false;
        } else if (objects.length > 0) {
            this.printIndent();
        }
        this.printWithNoIndent(objects);
        return this;
    }

    public void printIndent() {
        this.append(this.indent);
    }

    @NotNull
    public Printer printWithNoIndent(Object ... objects) {
        for (Object object : objects) {
            this.blankLineCountIncludingCurrent = 0;
            this.append(object);
        }
        return this;
    }

    @NotNull
    public Printer withholdIndentOnce() {
        this.withholdIndentOnce = true;
        return this;
    }

    @NotNull
    public Printer printlnWithNoIndent(Object ... objects) {
        this.printWithNoIndent(objects);
        this.printLineSeparator();
        return this;
    }

    @NotNull
    public Printer pushIndent() {
        this.indent = this.indent + this.indentUnit;
        return this;
    }

    @NotNull
    public Printer popIndent() {
        if (this.indent.length() < this.indentUnit.length()) {
            throw new IllegalStateException("No indentation to pop");
        }
        this.indent = this.indent.substring(this.indentUnit.length());
        return this;
    }

    @NotNull
    public Printer separated(Object separator, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                this.printlnWithNoIndent(separator);
            }
            this.printlnWithNoIndent(items[i]);
        }
        return this;
    }

    @NotNull
    public Printer separated(Object separator, Collection<?> items) {
        Iterator<?> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            this.printlnWithNoIndent(iterator2.next());
            if (!iterator2.hasNext()) continue;
            this.printlnWithNoIndent(separator);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return this.out.toString();
    }
}

