/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinPathsFromHomeDir
implements KotlinPaths {
    private final File homePath;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        this.homePath = homePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        return this.homePath;
    }

    @Override
    @NotNull
    public File getLibPath() {
        return new File(this.homePath, "lib");
    }

    @Override
    @NotNull
    public File getStdlibPath() {
        return this.getLibraryFile("kotlin-stdlib.jar");
    }

    @Override
    @NotNull
    public File getReflectPath() {
        return this.getLibraryFile("kotlin-reflect.jar");
    }

    @Override
    @NotNull
    public File getScriptRuntimePath() {
        return this.getLibraryFile("kotlin-script-runtime.jar");
    }

    @Override
    @NotNull
    public File getKotlinTestPath() {
        return this.getLibraryFile("kotlin-test.jar");
    }

    @Override
    @NotNull
    public File getStdlibSourcesPath() {
        return this.getLibraryFile("kotlin-stdlib-sources.jar");
    }

    @Override
    @NotNull
    public File getJsStdLibJarPath() {
        return this.getLibraryFile("kotlin-stdlib-js.jar");
    }

    @Override
    @NotNull
    public File getJsStdLibSrcJarPath() {
        return this.getLibraryFile("kotlin-stdlib-js-sources.jar");
    }

    @Override
    @NotNull
    public File getJsKotlinTestJarPath() {
        return this.getLibraryFile("kotlin-test-js.jar");
    }

    @Override
    @NotNull
    public File getAllOpenPluginJarPath() {
        return this.getLibraryFile("allopen-compiler-plugin.jar");
    }

    @Override
    @NotNull
    public File getNoArgPluginJarPath() {
        return this.getLibraryFile("noarg-compiler-plugin.jar");
    }

    @Override
    @NotNull
    public File getSamWithReceiverJarPath() {
        return this.getLibraryFile("sam-with-receiver-compiler-plugin.jar");
    }

    @Override
    @NotNull
    public File getTrove4jJarPath() {
        return this.getLibraryFile("trove4j");
    }

    @Override
    @NotNull
    public List<File> getCompilerClasspath() {
        return CollectionsKt.listOf(this.getStdlibPath(), this.getReflectPath(), this.getScriptRuntimePath(), this.getTrove4jJarPath());
    }

    @Override
    @NotNull
    public File getCompilerPath() {
        return this.getLibraryFile("kotlin-compiler.jar");
    }

    @NotNull
    private File getLibraryFile(@NotNull String fileName) {
        return new File(this.getLibPath(), fileName);
    }
}

