/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final boolean isVariableReassignment;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        CallableDescriptor operationDescriptor;
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression2) && ((operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2)) == null || operationDescriptor.getExtensionReceiverParameter() == null)) {
            return IntrinsicAssignmentTranslator.doTranslate(expression2, context);
        }
        return OverloadedAssignmentTranslator.doTranslate(expression2, context);
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression2);
        assert (expression2.getLeft() != null) : "No left-hand side: " + expression2.getText();
    }

    protected final AccessTranslator createAccessTranslator(@NotNull KtExpression left, boolean forceOrderOfEvaluation) {
        if (AssignmentTranslator.isValProperty(left, this.context())) {
            KtSimpleNameExpression simpleName = PsiUtils.getSimpleName(left);
            assert (simpleName != null);
            return BackingFieldAccessTranslator.newInstance(simpleName, this.context());
        }
        return AccessTranslationUtils.getAccessTranslator(left, this.context(), forceOrderOfEvaluation);
    }

    private static boolean isValProperty(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KtSimpleNameExpression simpleNameExpression = PsiUtils.getSimpleName(expression2);
        if (simpleNameExpression != null) {
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
            return descriptor2 instanceof PropertyDescriptor && !((PropertyDescriptor)descriptor2).isVar();
        }
        return false;
    }
}

