/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsArrayLiteral
extends JsLiteral {
    private final List<JsExpression> expressions;

    public JsArrayLiteral() {
        this.expressions = new SmartList<JsExpression>();
    }

    public JsArrayLiteral(List<JsExpression> expressions) {
        this.expressions = expressions;
    }

    public List<JsExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(JsVisitor v2) {
        v2.visitArray(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.expressions);
    }

    @Override
    public void traverse(JsVisitorWithContext v2, JsContext ctx) {
        if (v2.visit(this, ctx)) {
            v2.acceptList(this.expressions);
        }
        v2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsArrayLiteral deepCopy() {
        return new JsArrayLiteral(AstUtil.deepCopy(this.expressions)).withMetadataFrom(this);
    }
}

