/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.AutoboxingTransformer$WhenMappings;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\r*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010H\u0014J\u0014\u0010\u001a\u001a\u00020\r*\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AutoboxingTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isDispatchReceiver", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;)Z", "buildSafeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arg", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "resultType", "call", "Lkotlin/Function1;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "useAs", "type", "useAsVarargElement", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "backend.js"})
public final class AutoboxingTransformer
extends AbstractValueUsageTransformer
implements FileLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        this.transformChildrenVoid(irFile);
        PatchDeclarationParentsKt.patchDeclarationParents$default(irFile, null, 1, null);
    }

    @Override
    @NotNull
    protected IrExpression useAs(@NotNull IrExpression $receiver, @NotNull IrType type2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrType actualType;
        IrType irType;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        IrExpression irExpression = $receiver;
        if (irExpression instanceof IrCall) {
            IrFunction irFunction = ((IrCall)$receiver).getSymbol().getOwner();
            IrFunction it = irFunction;
            irType = it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend() ? this.getIrBuiltIns().getAnyNType() : ((IrCall)$receiver).getSymbol().getOwner().getReturnType();
        } else if (irExpression instanceof IrGetField) {
            irType = ((IrField)((IrGetField)$receiver).getSymbol().getOwner()).getType();
        } else if (irExpression instanceof IrTypeOperatorCall) {
            switch (AutoboxingTransformer$WhenMappings.$EnumSwitchMapping$0[((IrTypeOperatorCall)$receiver).getOperator().ordinal()]) {
                case 1: {
                    irType = ((IrTypeOperatorCall)$receiver).getTypeOperand();
                    break;
                }
                case 2: 
                case 3: {
                    irType = this.context.getIrBuiltIns().getAnyNType();
                    break;
                }
                default: {
                    irType = $receiver.getType();
                    break;
                }
            }
        } else {
            IrValueDeclaration value;
            irType = irExpression instanceof IrGetValue ? ((value = ((IrGetValue)$receiver).getSymbol().getOwner()) instanceof IrValueParameter && this.isDispatchReceiver((IrValueParameter)value) ? this.getIrBuiltIns().getAnyNType() : $receiver.getType()) : (actualType = $receiver.getType());
        }
        if (IrTypePredicatesKt.isNothing(IrTypesKt.makeNotNull(actualType))) {
            return $receiver;
        }
        IrType expectedType = type2;
        IrClass actualInlinedClass = InlineClassesKt.getInlinedClass(actualType);
        IrClass expectedInlinedClass = InlineClassesKt.getInlinedClass(expectedType);
        if (actualInlinedClass == null && expectedInlinedClass == null) {
            return $receiver;
        }
        if (actualInlinedClass != null && expectedInlinedClass == null) {
            irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBoxIntrinsic();
        } else if (actualInlinedClass == null && expectedInlinedClass != null) {
            irSimpleFunctionSymbol = this.context.getIntrinsics().getJsUnboxIntrinsic();
        } else {
            return $receiver;
        }
        IrSimpleFunctionSymbol function2 = irSimpleFunctionSymbol;
        return this.buildSafeCall($receiver, actualType, expectedType, (Function1<? super IrExpression, ? extends IrExpression>)new Function1<IrExpression, IrExpression>(function2, expectedType, actualType){
            final /* synthetic */ IrSimpleFunctionSymbol $function;
            final /* synthetic */ IrType $expectedType;
            final /* synthetic */ IrType $actualType;

            @NotNull
            public final IrExpression invoke(@NotNull IrExpression arg) {
                IrCall irCall;
                Intrinsics.checkParameterIsNotNull(arg, "arg");
                IrCall it = irCall = JsIrBuilder.INSTANCE.buildCall(this.$function, this.$expectedType, CollectionsKt.listOf(this.$actualType, this.$expectedType));
                it.putValueArgument(0, arg);
                return irCall;
            }
            {
                this.$function = irSimpleFunctionSymbol;
                this.$expectedType = irType;
                this.$actualType = irType2;
                super(1);
            }
        });
    }

    private final IrExpression buildSafeCall(IrExpression arg, IrType actualType, IrType resultType, Function1<? super IrExpression, ? extends IrExpression> call2) {
        JsIrBuilder jsIrBuilder;
        if (!IrTypeUtilsKt.isNullable(actualType)) {
            return call2.invoke(arg);
        }
        JsIrBuilder $receiver = jsIrBuilder = JsIrBuilder.INSTANCE;
        IrVariable tmp = JsIrBuilder.buildVar$default($receiver, actualType, null, null, false, false, false, arg, 60, null);
        IrCall irCall = JsIrBuilder.buildCall$default($receiver, this.getIrBuiltIns().getEqeqSymbol(), null, null, 6, null);
        IrType irType = resultType;
        JsIrBuilder jsIrBuilder2 = $receiver;
        IrCall $receiver2 = irCall;
        $receiver2.putValueArgument(0, $receiver.buildGetValue((IrValueSymbol)tmp.getSymbol()));
        $receiver2.putValueArgument(1, $receiver.buildNull(this.getIrBuiltIns().getNothingNType()));
        IrCall irCall2 = irCall;
        IrWhen nullCheck = jsIrBuilder2.buildIfElse(irType, irCall2, $receiver.buildNull(this.getIrBuiltIns().getNothingNType()), call2.invoke($receiver.buildGetValue((IrValueSymbol)tmp.getSymbol())));
        return $receiver.buildBlock(resultType, CollectionsKt.listOf(tmp, nullCheck));
    }

    @Override
    @NotNull
    protected IrExpression useAsVarargElement(@NotNull IrExpression $receiver, @NotNull IrVararg expression2) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return this.useAs($receiver, InlineClassesKt.isInlined($receiver.getType()) ? this.getIrBuiltIns().getAnyNType() : expression2.getVarargElementType());
    }

    private final boolean isDispatchReceiver(@NotNull IrValueParameter $receiver) {
        IrDeclarationParent parent2 = $receiver.getParent();
        if (parent2 instanceof IrClass) {
            return true;
        }
        return parent2 instanceof IrFunction && Intrinsics.areEqual(((IrFunction)parent2).getDispatchReceiverParameter(), $receiver);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public AutoboxingTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context.getIrBuiltIns());
        this.context = context;
    }
}

