/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;

public class CodegenStatementVisitor
extends KtVisitor<StackValue, StackValue> {
    private final ExpressionCodegen codegen;

    public CodegenStatementVisitor(ExpressionCodegen codegen) {
        this.codegen = codegen;
    }

    @Override
    public StackValue visitKtElement(@NotNull KtElement element, StackValue receiver2) {
        return element.accept(this.codegen, receiver2);
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression2, StackValue receiver2) {
        return this.codegen.generateIfExpression(expression2, true);
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression2, StackValue data) {
        return this.codegen.generateTryExpression(expression2, true);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data) {
        return this.codegen.visitNamedFunction(function2, data, true);
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression2, StackValue data) {
        return this.codegen.generateWhenExpression(expression2, true);
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression2, StackValue data) {
        return this.codegen.generateBlock(expression2, true);
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression2, StackValue receiver2) {
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null) : "Label expression should have base one: " + expression2.getText();
        return baseExpression.accept(this, receiver2);
    }
}

