/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    public static final Key<Boolean> LAF_WITH_THEME_KEY;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final Pattern CLOSE_TAG_PATTERN;
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    public static float DEF_SYSTEM_FONT_SIZE;
    private static final Ref<Boolean> ourRetina;
    private static final AtomicReference<Boolean> jreHiDPI;
    private static volatile boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    @Deprecated
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    @Deprecated
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable JBUI.ScaleContext ctx) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI.get() != null) {
            return jreHiDPI.get();
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        synchronized (atomicReference) {
            if (jreHiDPI.get() != null) {
                return jreHiDPI.get();
            }
            jreHiDPI.set(false);
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                return false;
            }
            jreHiDPI_earlierVersion = true;
            if (SystemInfo.isJetBrainsJvm) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (ge instanceof SunGraphicsEnvironment) {
                        Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleOn", new Class[0]);
                        jreHiDPI.set(m != null && (Boolean)m.invoke((Object)ge, new Object[0]) != false);
                        jreHiDPI_earlierVersion = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (SystemInfo.isMac) {
                jreHiDPI.set(true);
            }
            return jreHiDPI.get();
        }
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    @Deprecated
    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        LinePainter2D.paint((Graphics2D)g, x1, y1, x2, y2);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelForeground() {
        return JBColor.namedColor("Label.foreground", new JBColor(Gray._0, Gray.xBB));
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type2);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(45);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        return bufferedImage;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        UIUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        boolean hasDstSize;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        Graphics invG = null;
        double scale = 1.0;
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean bl = hasDstSize = dw >= 0 && dh >= 0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if ((scale = hidpiImage.getScale()) == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        final double _scale = scale;
        Function<Integer, Integer> size = new Function<Integer, Integer>(){

            @Override
            public Integer fun(Integer size) {
                return (int)Math.round((double)size.intValue() * _scale);
            }
        };
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = (Integer)size.fun(dw);
                dh = (Integer)size.fun(dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = (Integer)size.fun(srcBounds.x);
                int sy = (Integer)size.fun(srcBounds.y);
                int sw = srcBounds.width >= 0 ? (Integer)size.fun(srcBounds.width) : (Integer)size.fun(userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? (Integer)size.fun(srcBounds.height) : (Integer)size.fun(userHeight) - sy;
                if (!hasDstSize) {
                    dw = (Integer)size.fun(userWidth);
                    dh = (Integer)size.fun(userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        if (JBUI.SCALE_VERBOSE) {
            LOG.info(String.format("Label font: %s, %d", font.getFontName(), font.getSize()));
        }
        if (SystemInfo.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (JBUI.SCALE_VERBOSE) {
                LOG.info(String.format("gnome.Xft/DPI: %s", value));
            }
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = UIUtil.isJreHiDPIEnabled() ? 1.0f : JBUI.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                if (JBUI.SCALE_VERBOSE) {
                    LOG.info(String.format("DEF_SYSTEM_FONT_SIZE: %.2f", Float.valueOf(DEF_SYSTEM_FONT_SIZE)));
                }
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * UIUtil.getScreenScale();
                font = font.deriveFont(size);
                if (JBUI.SCALE_VERBOSE) {
                    LOG.info(String.format("(Not-JB JRE) reset font size: %.2f", Float.valueOf(size)));
                }
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            if (JBUI.SCALE_VERBOSE) {
                LOG.info(String.format("Windows sys font: %s, %d", winFont.getFontName(), winFont.getSize()));
            }
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
        if (JBUI.SCALE_VERBOSE) {
            LOG.info(String.format("ourSystemFontData: %s, %d", UIUtil.ourSystemFontData.first, UIUtil.ourSystemFontData.second));
        }
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUI.discreteScale((float)dpi / 96.0f);
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(103);
            }
            return jBIterable;
        }
        Container container2 = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container2.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        return jBIterable;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = UIManager.getColor("List.background");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(142);
        }
        return color;
    }

    static {
        LAF_WITH_THEME_KEY = Key.create("Laf.with.ui.theme");
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
        INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
        CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(Gray.x9B, Gray.x4B));
        SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        DEF_SYSTEM_FONT_SIZE = 12.0f;
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        jreHiDPI = new AtomicReference();
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(new Function<Component, JBIterable<Component>>(){

            @Override
            public JBIterable<Component> fun(@NotNull Component c) {
                if (c == null) {
                    16.$$$reportNull$$$0(0);
                }
                JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result2 = result2.append(orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result2 = result2.append(Collections.singletonList(jpm));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/UIUtil$16", "fun"));
            }
        });
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Document document;
                if (e == null) {
                    22.$$$reportNull$$$0(0);
                }
                if ((document = e.getDocument()) instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (final UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ((UndoManager)listener).discardAllEdits();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$22", "textChanged"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 83: 
            case 92: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 123: 
            case 127: 
            case 129: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 83: 
            case 92: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 123: 
            case 127: 
            case 129: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 3: 
            case 18: 
            case 20: 
            case 22: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 77: 
            case 79: 
            case 81: 
            case 86: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 121: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 25: 
            case 44: 
            case 87: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 27: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 83: 
            case 92: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 123: 
            case 127: 
            case 129: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 32: 
            case 33: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 78: 
            case 80: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 82: 
            case 89: 
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 85: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 93: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 125: 
            case 126: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignSource";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 109: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 142: 
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 143: 
            case 144: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getListUnfocusedSelectionBackground";
                break;
            }
            case 149: 
            case 151: 
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 150: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionForeground";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 155: 
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 156: 
            case 157: 
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeUnfocusedSelectionBackground";
                break;
            }
            case 161: 
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 162: 
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionForeground";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFont";
                break;
            }
            case 166: 
            case 169: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 167: 
            case 168: 
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableUnfocusedSelectionBackground";
                break;
            }
            case 173: 
            case 175: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 174: 
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawFramingLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWindowClientPropertyTrue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 27: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 83: 
            case 92: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 123: 
            case 127: 
            case 129: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 107: 
            case 108: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignBorder";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "redirectKeystrokes";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 83: 
            case 92: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 123: 
            case 127: 
            case 129: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }
    }

    private static class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }

    public static class JBHtmlEditorKit
    extends HTMLEditorKit {
        private final StyleSheet style;
        private final HyperlinkListener myHyperlinkListener;

        @Override
        public Cursor getDefaultCursor() {
            return null;
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
            ss.addStyleSheet(styles);
            HTMLDocument doc = new HTMLDocument(ss);
            doc.setParser(this.getParser());
            doc.setAsynchronousLoadPriority(4);
            doc.setTokenThreshold(100);
            return doc;
        }

        public static StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(UIUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : DEFAULT_HTML_KIT_CSS);
            style.addRule("code { font-size: 100%; }");
            style.addRule("small { font-size: small; }");
            style.addRule("a { text-decoration: none;}");
            style.addRule("ul { margin-left-ltr: 10; margin-right-rtl: 10; }");
            style.addRule("ol { margin-left-ltr: 22; margin-right-rtl: 22; }");
            return style;
        }

        @Override
        public void install(final JEditorPane pane) {
            super.install(pane);
            if (pane != null) {
                pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Font font = UIUtil.getLabelFont();
                        pane.setFont(font);
                        pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                        pane.removePropertyChangeListener(this);
                    }
                });
                pane.addHyperlinkListener(this.myHyperlinkListener);
                List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
                List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
                if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
                    HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
                    pane.removeMouseListener(oldLinkController);
                    pane.removeMouseMotionListener(oldLinkController);
                    MouseExitSupportLinkController newLinkController = new MouseExitSupportLinkController();
                    pane.addMouseListener(newLinkController);
                    pane.addMouseMotionListener(newLinkController);
                }
            }
        }

        @NotNull
        private static List<HTMLEditorKit.LinkController> filterLinkControllerListeners(@NotNull Object[] listeners) {
            if (listeners == null) {
                JBHtmlEditorKit.$$$reportNull$$$0(0);
            }
            List<HTMLEditorKit.LinkController> list2 = ContainerUtil.mapNotNull(listeners, new Function<Object, HTMLEditorKit.LinkController>(){

                @Override
                public HTMLEditorKit.LinkController fun(Object o) {
                    return ObjectUtils.tryCast(o, HTMLEditorKit.LinkController.class);
                }
            });
            if (list2 == null) {
                JBHtmlEditorKit.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void deinstall(JEditorPane c) {
            c.removeHyperlinkListener(this.myHyperlinkListener);
            super.deinstall(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listeners";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$JBHtmlEditorKit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$JBHtmlEditorKit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterLinkControllerListeners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "filterLinkControllerListeners";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class DetectRetinaKit {
        private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = ContainerUtil.createWeakMap();

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }
    }
}

