/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.plugins.gradle.integrations.maven.MavenRepositoriesHolder;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

class ImportMavenRepositoriesTask {
    @NotNull
    private final MavenRemoteRepository mavenCentralRemoteRepository;
    private final Project myProject;

    ImportMavenRepositoriesTask(Project project) {
        this.myProject = project;
        this.mavenCentralRemoteRepository = new MavenRemoteRepository("central", null, "https://repo1.maven.org/maven2/", null, null, null);
    }

    void schedule() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ReadAction.nonBlocking(this::performTask).inSmartMode(this.myProject).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void performTask() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        ArrayList psiFileList = ContainerUtil.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            String buildScript;
            String modulePath;
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || (modulePath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)) == null || StringUtil.isEmpty((String)(buildScript = FileUtil.findFileInProvidedPath((String)modulePath, (String[])new String[]{"build.gradle"}))) || (virtualFile = localFileSystem.refreshAndFindFileByPath(buildScript)) == null || (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) == null) continue;
            psiFileList.add(psiFile);
        }
        PsiFile[] psiFiles = psiFileList.toArray(PsiFile.EMPTY_ARRAY);
        Set mavenRemoteRepositories = (Set)ReadAction.compute(() -> {
            HashSet myRemoteRepositories = ContainerUtil.newHashSet();
            for (PsiFile psiFile : psiFiles) {
                ArrayList repositoriesBlocks = ContainerUtil.newArrayList();
                repositoriesBlocks.addAll(ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)psiFile, "repositories"));
                for (GrClosableBlock grClosableBlock : ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)psiFile, "buildscript", "subprojects", "allprojects", "project", "configure")) {
                    repositoriesBlocks.addAll(ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)grClosableBlock, "repositories"));
                }
                for (GrClosableBlock grClosableBlock : repositoriesBlocks) {
                    myRemoteRepositories.addAll(this.findMavenRemoteRepositories(grClosableBlock));
                }
            }
            return myRemoteRepositories;
        });
        if (mavenRemoteRepositories == null || mavenRemoteRepositories.isEmpty()) {
            return;
        }
        MavenRepositoriesHolder.getInstance(this.myProject).update(mavenRemoteRepositories);
        MavenProjectIndicesManager.getInstance((Project)this.myProject).scheduleUpdateIndicesList(indexes -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            List<String> repositoriesWithEmptyIndex = indexes.stream().filter(index -> index.getUpdateTimestamp() == -1L && index.getFailureMessage() == null && MavenRepositoriesHolder.getInstance(this.myProject).contains(index.getRepositoryPathOrUrl())).map(MavenIndex::getRepositoryPathOrUrl).collect(Collectors.toList());
            MavenRepositoriesHolder.getInstance(this.myProject).updateNotIndexedUrls(repositoriesWithEmptyIndex);
        });
    }

    @NotNull
    private static Collection<? extends GrClosableBlock> findClosableBlocks(@NotNull PsiElement element, String ... blockNames) {
        if (element == null) {
            ImportMavenRepositoriesTask.$$$reportNull$$$0(0);
        }
        if (blockNames == null) {
            ImportMavenRepositoriesTask.$$$reportNull$$$0(1);
        }
        List methodCalls = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, GrMethodCall.class);
        List list = ContainerUtil.mapNotNull((Collection)methodCalls, call -> {
            if (call == null || call.getClosureArguments().length != 1) {
                return null;
            }
            GrExpression expression = call.getInvokedExpression();
            return ArrayUtil.contains((String)expression.getText(), (String[])blockNames) ? call.getClosureArguments()[0] : null;
        });
        if (list == null) {
            ImportMavenRepositoriesTask.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private Collection<? extends MavenRemoteRepository> findMavenRemoteRepositories(@Nullable GrClosableBlock repositoriesBlock) {
        HashSet myRemoteRepositories = ContainerUtil.newHashSet();
        block0: for (GrMethodCall repo : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repositoriesBlock, GrMethodCall.class)) {
            GrExpression expression;
            GrAssignmentExpression statement;
            List assignmentExpressionList;
            String textUri;
            URI urlArgumentValue;
            String expressionText = repo.getInvokedExpression().getText();
            if ("mavenCentral".equals(expressionText)) {
                myRemoteRepositories.add(this.mavenCentralRemoteRepository);
                continue;
            }
            if ("mavenRepo".equals(expressionText)) {
                for (GrNamedArgument namedArgument : repo.getNamedArguments()) {
                    if (!"url".equals(namedArgument.getLabelName())) continue;
                    urlArgumentValue = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(namedArgument.getExpression());
                    if (urlArgumentValue == null) continue block0;
                    textUri = urlArgumentValue.toString();
                    myRemoteRepositories.add(new MavenRemoteRepository(textUri, null, textUri, null, null, null));
                    continue block0;
                }
                continue;
            }
            if (!"maven".equals(expressionText) || repo.getClosureArguments().length <= 0) continue;
            List applicationStatementList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repo.getClosureArguments()[0], GrApplicationStatement.class);
            if (!applicationStatementList.isEmpty()) {
                URI urlArgumentValue2;
                GrApplicationStatement statement2 = (GrApplicationStatement)applicationStatementList.get(0);
                if (statement2 == null) continue;
                GrExpression expression2 = statement2.getInvokedExpression();
                if ("url".equals(expression2.getText()) && (urlArgumentValue2 = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(statement2.getExpressionArguments()[0])) != null) {
                    String textUri2 = urlArgumentValue2.toString();
                    myRemoteRepositories.add(new MavenRemoteRepository(textUri2, null, textUri2, null, null, null));
                }
            }
            if ((assignmentExpressionList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repo.getClosureArguments()[0], GrAssignmentExpression.class)).isEmpty() || (statement = (GrAssignmentExpression)assignmentExpressionList.get(0)) == null || !"url".equals((expression = statement.getLValue()).getText()) || (urlArgumentValue = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(statement.getRValue())) == null) continue;
            textUri = urlArgumentValue.toString();
            myRemoteRepositories.add(new MavenRemoteRepository(textUri, null, textUri, null, null, null));
        }
        HashSet hashSet = myRemoteRepositories;
        if (hashSet == null) {
            ImportMavenRepositoriesTask.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private static URI resolveUriFromSimpleExpression(@Nullable GrExpression expression) {
        if (expression == null) {
            return null;
        }
        try {
            URI uri;
            if (expression instanceof PsiLiteral && (uri = new URI(String.valueOf(((PsiLiteral)expression).getValue()))).getScheme() != null && StringUtil.startsWith((CharSequence)uri.getScheme(), (CharSequence)"http")) {
                return uri;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        try {
            PsiReference reference = expression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement element = reference.resolve();
            if (element instanceof GrVariable) {
                List grLiterals = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, GrLiteral.class);
                if (grLiterals.isEmpty()) {
                    return null;
                }
                URI uri = new URI(String.valueOf(((GrLiteral)grLiterals.get(0)).getValue()));
                if (uri.getScheme() != null && StringUtil.startsWith((CharSequence)"http", (CharSequence)uri.getScheme())) {
                    return uri;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/integrations/maven/ImportMavenRepositoriesTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/integrations/maven/ImportMavenRepositoriesTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findClosableBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findMavenRemoteRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClosableBlocks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

