/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;

public final class AllInDirectoryGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        sourceElement.set((Object)configurationData.sourceElement);
        ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
        Function1 createFilter = e -> GradleExecutionSettingsUtil.createTestWildcardFilter(false);
        if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, context.getModule(), configurationData.sources, it -> it, createFilter)) {
            return false;
        }
        configuration.setName(AllInDirectoryGradleConfigurationProducer.suggestName(configurationData.module));
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        String projectPath = configuration.getSettings().getExternalProjectPath();
        if (!StringUtil.equals((CharSequence)configurationData.projectPath, (CharSequence)projectPath)) {
            return false;
        }
        if (configurationData.sources.isEmpty()) {
            return false;
        }
        for (VirtualFile source : configurationData.sources) {
            if (AllInDirectoryGradleConfigurationProducer.hasTasksInConfiguration(source, context.getProject(), configuration.getSettings())) continue;
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        return scriptParameters.contains(GradleExecutionSettingsUtil.createTestWildcardFilter(true));
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        ConfigurationData configurationData;
        if (fromContext == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (performRunnable == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((configurationData = this.extractConfigurationData(context)) == null) {
            LOG.warn("Cannot extract configuration data from context, uses raw run configuration");
            performRunnable.run();
            return;
        }
        String locationName = String.format("'%s'", configurationData.module.getName());
        DataContext dataContext = TestTasksChooser.contextWithLocationName(context.getDataContext(), locationName);
        this.getTestTasksChooser().chooseTestTasks(context.getProject(), dataContext, configurationData.sources, tasks -> {
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
            ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
            Function1 createFilter = e -> GradleExecutionSettingsUtil.createTestWildcardFilter(false);
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, context.getModule(), tasks, configurationData.sources, it -> it, createFilter)) {
                LOG.warn("Cannot apply package test configuration, uses raw run configuration");
                performRunnable.run();
                return;
            }
            configuration.setName(AllInDirectoryGradleConfigurationProducer.suggestName(configurationData.module));
            performRunnable.run();
        });
    }

    @Nullable
    private ConfigurationData extractConfigurationData(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return null;
        }
        PsiElement contextLocation = context.getPsiLocation();
        if (contextLocation == null) {
            return null;
        }
        if (AllInPackageGradleConfigurationProducer.extractPackage(contextLocation) != null) {
            return null;
        }
        if (!(contextLocation instanceof PsiFileSystemItem)) {
            return null;
        }
        PsiFileSystemItem directory = (PsiFileSystemItem)contextLocation;
        if (!directory.isDirectory()) {
            return null;
        }
        List<VirtualFile> sources = AllInDirectoryGradleConfigurationProducer.findTestSourcesUnderDirectory(module, directory.getVirtualFile());
        return new ConfigurationData(module, (PsiElement)directory, sources, projectPath);
    }

    private static List<VirtualFile> findTestSourcesUnderDirectory(@NotNull Module module, @NotNull VirtualFile directory) {
        DataNode moduleDataNode;
        if (module == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((moduleDataNode = ExternalSystemApiUtil.findModuleData((Module)module, (ProjectSystemId)GradleConstants.SYSTEM_ID)) == null) {
            return Collections.emptyList();
        }
        String rootPath = directory.getPath();
        return ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST).stream().map(DataNode::getData).flatMap(it -> it.getSourceFolders().stream()).filter(it -> FileUtil.isAncestor((String)rootPath, (String)it, (boolean)false)).map(it -> VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)false)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static String suggestName(@NotNull Module module) {
        if (module == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(6);
        }
        return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{module.getName()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/AllInDirectoryGradleConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performRunnable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/AllInDirectoryGradleConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFirstRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestSourcesUnderDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConfigurationData {
        @NotNull
        public final Module module;
        @NotNull
        public final PsiElement sourceElement;
        @NotNull
        public final List<VirtualFile> sources;
        @NotNull
        public final String projectPath;

        private ConfigurationData(@NotNull Module module, @NotNull PsiElement sourceElement, @NotNull List<VirtualFile> sources, @NotNull String projectPath) {
            if (module == null) {
                ConfigurationData.$$$reportNull$$$0(0);
            }
            if (sourceElement == null) {
                ConfigurationData.$$$reportNull$$$0(1);
            }
            if (sources == null) {
                ConfigurationData.$$$reportNull$$$0(2);
            }
            if (projectPath == null) {
                ConfigurationData.$$$reportNull$$$0(3);
            }
            this.module = module;
            this.sourceElement = sourceElement;
            this.sources = sources;
            this.projectPath = projectPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sources";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectPath";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/AllInDirectoryGradleConfigurationProducer$ConfigurationData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

