/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

final class GradleGroovyScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<ExternalSystemRunConfiguration> {
    GradleGroovyScriptRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        if (!GradleConstants.SYSTEM_ID.equals((Object)taskExecutionSettings.getExternalSystemId())) {
            return false;
        }
        Location contextLocation = context.getLocation();
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation)) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(module);
        if (projectPath == null) {
            VirtualFile virtualFile = contextLocation.getVirtualFile();
            String string = projectPath = virtualFile != null ? virtualFile.getPath() : null;
        }
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = GradleRunnerUtil.getTasksTarget(contextLocation);
        taskExecutionSettings.setExternalProjectPath(projectPath);
        taskExecutionSettings.setTaskNames(tasksToRun);
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName((Project)module.getProject(), (ExternalSystemTaskExecutionSettings)taskExecutionSettings));
        return true;
    }

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        Location contextLocation = context.getLocation();
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation)) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        List<String> tasks = GradleRunnerUtil.getTasksTarget(contextLocation);
        List taskNames = configuration.getSettings().getTaskNames();
        if (tasks.isEmpty() && taskNames.isEmpty()) {
            return true;
        }
        return tasks.containsAll(taskNames) && !taskNames.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleGroovyScriptRunConfigurationProducer", "getConfigurationFactory"));
    }
}

