/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.version;

import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVConstants;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import hidden.org.apache.jackrabbit.webdav.xml.Namespace;
import hidden.org.apache.jackrabbit.webdav.xml.XmlSerializable;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionsInfo
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(OptionsInfo.class);
    private final Set entriesLocalNames = new HashSet();

    public OptionsInfo(String[] entriesLocalNames) {
        if (entriesLocalNames != null) {
            for (int i = 0; i < entriesLocalNames.length; ++i) {
                this.entriesLocalNames.add(entriesLocalNames[i]);
            }
        }
    }

    private OptionsInfo() {
    }

    public boolean containsElement(String localName, Namespace namespace) {
        if (DeltaVConstants.NAMESPACE.equals(namespace)) {
            return this.entriesLocalNames.contains(localName);
        }
        return false;
    }

    public Element toXml(Document document) {
        Element optionsElem = DomUtil.createElement(document, "options", DeltaVConstants.NAMESPACE);
        Iterator it = this.entriesLocalNames.iterator();
        while (it.hasNext()) {
            String localName = (String)it.next();
            DomUtil.addChildElement(optionsElem, localName, DeltaVConstants.NAMESPACE);
        }
        return optionsElem;
    }

    public static OptionsInfo createFromXml(Element optionsElement) throws DavException {
        if (!DomUtil.matches(optionsElement, "options", DeltaVConstants.NAMESPACE)) {
            log.warn("DAV:options element expected");
            throw new DavException(400);
        }
        OptionsInfo oInfo = new OptionsInfo();
        ElementIterator it = DomUtil.getChildren(optionsElement);
        while (it.hasNext()) {
            oInfo.entriesLocalNames.add(it.nextElement().getLocalName());
        }
        return oInfo;
    }
}

