/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.settings;

import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.editorconfig.Utils;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigExportProviderEP;
import org.editorconfig.settings.EditorConfigListener;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigConfigurable
extends CodeStyleSettingsProvider
implements GeneralCodeStyleOptionsProvider {
    private JBCheckBox myEnabled;

    @Nullable
    public JComponent createComponent() {
        this.myEnabled = new JBCheckBox(EditorConfigBundle.message("config.enable"));
        JPanel result2 = new JPanel();
        result2.setLayout(new BoxLayout(result2, 2));
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        result2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)EditorConfigBundle.message("config.title"), (boolean)false));
        panel.add((Component)this.myEnabled);
        JLabel warning = new JLabel(EditorConfigBundle.message("config.warning"));
        warning.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        warning.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        panel.add(warning);
        panel.setAlignmentY(0.0f);
        result2.add(panel);
        JButton export = new JButton(EditorConfigBundle.message("config.export"));
        export.addActionListener(event -> {
            Project project;
            Component parent = UIUtil.findUltimateParent((Component)result2);
            if (parent instanceof IdeFrame && (project = ((IdeFrame)parent).getProject()) != null) {
                if (EditorConfigExportProviderEP.tryExportViaProviders(project)) {
                    return;
                }
                Utils.export(project);
            }
        });
        export.setAlignmentY(0.0f);
        result2.add(export);
        return result2;
    }

    public boolean isModified(CodeStyleSettings settings) {
        return this.myEnabled.isSelected() != ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public void apply(CodeStyleSettings settings) {
        boolean newValue;
        ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED = newValue = this.myEnabled.isSelected();
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        ((EditorConfigListener)bus.syncPublisher(EditorConfigSettings.EDITOR_CONFIG_ENABLED_TOPIC)).valueChanged(newValue);
    }

    public void reset(CodeStyleSettings settings) {
        this.myEnabled.setSelected(((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED);
    }

    public void disposeUIResources() {
        this.myEnabled = null;
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        if (null == null) {
            EditorConfigConfigurable.$$$reportNull$$$0(0);
        }
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new EditorConfigSettings(settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/settings/EditorConfigConfigurable", "createSettingsPage"));
    }
}

