/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.yaml.snakeyaml;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.org.yaml.snakeyaml.Dumper;
import org.gradle.internal.impldep.org.yaml.snakeyaml.DumperOptions;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.Tag;
import org.gradle.internal.impldep.org.yaml.snakeyaml.representer.Representer;
import org.gradle.internal.impldep.org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDumper {
    private boolean useGlobalTag;
    private DumperOptions.FlowStyle flowStyle;
    private DumperOptions options;
    private Representer representer;
    private Set<Class<? extends Object>> classTags;

    public JavaBeanDumper(boolean useGlobalTag) {
        this.useGlobalTag = useGlobalTag;
        this.flowStyle = DumperOptions.FlowStyle.BLOCK;
        this.classTags = new HashSet<Class<? extends Object>>();
    }

    public JavaBeanDumper() {
        this(false);
    }

    public JavaBeanDumper(Representer representer, DumperOptions options) {
        this.options = options;
        this.representer = representer;
    }

    public void dump(Object data, Writer output) {
        Representer repr;
        DumperOptions doptions;
        if (this.options == null) {
            doptions = new DumperOptions();
            if (!this.useGlobalTag) {
                doptions.setExplicitRoot(Tag.MAP);
            }
            doptions.setDefaultFlowStyle(this.flowStyle);
        } else {
            doptions = this.options;
        }
        if (this.representer == null) {
            repr = new Representer();
            for (Class<? extends Object> clazz : this.classTags) {
                repr.addClassTag(clazz, Tag.MAP);
            }
        } else {
            repr = this.representer;
        }
        Dumper dumper = new Dumper(repr, doptions);
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(data);
        dumper.dump(list.iterator(), output, new Resolver());
    }

    public String dump(Object data) {
        StringWriter buffer = new StringWriter();
        this.dump(data, buffer);
        return buffer.toString();
    }

    public boolean isUseGlobalTag() {
        return this.useGlobalTag;
    }

    public void setUseGlobalTag(boolean useGlobalTag) {
        this.useGlobalTag = useGlobalTag;
    }

    public DumperOptions.FlowStyle getFlowStyle() {
        return this.flowStyle;
    }

    public void setFlowStyle(DumperOptions.FlowStyle flowStyle) {
        this.flowStyle = flowStyle;
    }

    public void setMapTagForBean(Class<? extends Object> clazz) {
        this.classTags.add(clazz);
    }
}

