/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.transfer;

import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;

public class ArtifactTransferException
extends RepositoryException {
    private final Artifact artifact;
    private final RemoteRepository repository;

    static String getString(String prefix, RemoteRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getUrl() + ")";
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, String message) {
        super(message);
        this.artifact = artifact;
        this.repository = repository;
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, Throwable cause) {
        super("Could not transfer artifact " + artifact + ArtifactTransferException.getString(" from/to ", repository) + ArtifactTransferException.getMessage(": ", cause), cause);
        this.artifact = artifact;
        this.repository = repository;
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.artifact = artifact;
        this.repository = repository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

