/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.util.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Buffer;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.BufferException;

public class ArrayBuffer
implements Buffer {
    private byte[] buffer;
    private boolean closed;
    private int count;
    private int limit;

    public ArrayBuffer() {
        this(16);
    }

    public ArrayBuffer(int size) {
        this(size, size);
    }

    public ArrayBuffer(int size, int limit) {
        this.buffer = new byte[size];
        this.limit = limit;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer, 0, this.count);
    }

    public Buffer allocate() throws IOException {
        return new Segment(this, this.count);
    }

    public String encode() throws IOException {
        return this.encode("UTF-8");
    }

    public String encode(String charset) throws IOException {
        return new String(this.buffer, 0, this.count, charset);
    }

    public Buffer append(byte[] array) throws IOException {
        return this.append(array, 0, array.length);
    }

    public Buffer append(byte[] array, int off, int size) throws IOException {
        if (this.closed) {
            throw new BufferException("Buffer is closed", new Object[0]);
        }
        if (size + this.count > this.buffer.length) {
            this.expand(this.count + size);
        }
        if (size > 0) {
            System.arraycopy(array, off, this.buffer, this.count, size);
            this.count += size;
        }
        return this;
    }

    private void expand(int capacity) throws IOException {
        if (capacity > this.limit) {
            throw new BufferException("Capacity limit %s exceeded", this.limit);
        }
        int resize = this.buffer.length * 2;
        int size = Math.max(capacity, resize);
        byte[] temp = new byte[size];
        System.arraycopy(this.buffer, 0, temp, 0, this.count);
        this.buffer = temp;
    }

    public void clear() throws IOException {
        if (this.closed) {
            throw new BufferException("Buffer is closed", new Object[0]);
        }
        this.count = 0;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    private class Segment
    implements Buffer {
        private Buffer parent;
        private boolean closed;
        private int start;
        private int length;

        public Segment(Buffer parent, int start) {
            this.parent = parent;
            this.start = start;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(ArrayBuffer.this.buffer, this.start, this.length);
        }

        public Buffer allocate() throws IOException {
            return new Segment(this, ArrayBuffer.this.count);
        }

        public String encode() throws IOException {
            return this.encode("UTF-8");
        }

        public String encode(String charset) throws IOException {
            return new String(ArrayBuffer.this.buffer, this.start, this.length, charset);
        }

        public Buffer append(byte[] array) throws IOException {
            return this.append(array, 0, array.length);
        }

        public Buffer append(byte[] array, int off, int size) throws IOException {
            if (this.closed) {
                throw new BufferException("Buffer is closed", new Object[0]);
            }
            if (size > 0) {
                this.parent.append(array, off, size);
                this.length += size;
            }
            return this;
        }

        public void clear() throws IOException {
            this.length = 0;
        }

        public void close() throws IOException {
            this.closed = true;
        }
    }
}

