/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.http.Cookie;
import org.gradle.internal.impldep.org.simpleframework.http.core.Entity;
import org.gradle.internal.impldep.org.simpleframework.http.core.Header;
import org.gradle.internal.impldep.org.simpleframework.http.core.Tracker;
import org.gradle.internal.impldep.org.simpleframework.http.session.Session;
import org.gradle.internal.impldep.org.simpleframework.http.session.SessionManager;
import org.gradle.internal.impldep.org.simpleframework.http.session.SessionProvider;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseException;

class CookieTracker
implements Tracker {
    private final SessionProvider provider;

    public CookieTracker() {
        this(1200L, TimeUnit.SECONDS);
    }

    public CookieTracker(long duration, TimeUnit unit) {
        this.provider = new SessionManager(duration, unit);
    }

    public Session getSession(Entity entity) throws LeaseException {
        return this.getSession(entity, true);
    }

    public Session getSession(Entity entity, boolean create) throws LeaseException {
        Header header = entity.getHeader();
        Cookie cookie = header.getSession(create);
        if (cookie == null) {
            return null;
        }
        return this.getSession(cookie, create);
    }

    private Session getSession(Cookie cookie, boolean create) throws LeaseException {
        String value = cookie.getValue();
        if (value == null) {
            return null;
        }
        return this.provider.open(value, create);
    }

    public void close() throws LeaseException {
        this.provider.close();
    }
}

