/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.org.junit.platform.engine.FilterResult;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.AbstractClassNameFilter;

class ExcludeClassNameFilter
extends AbstractClassNameFilter {
    ExcludeClassNameFilter(String ... patterns) {
        super(patterns);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.excluded(this.formatExclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.included(this.formatInclusionReason(className)));
    }

    private String formatExclusionReason(String className, Pattern pattern) {
        return String.format("Class name [%s] matches excluded pattern: '%s'", className, pattern);
    }

    private String formatInclusionReason(String className) {
        return String.format("Class name [%s] does not match any excluded pattern: %s", className, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> !this.findMatchingPattern((String)className).isPresent();
    }

    public String toString() {
        return "Excludes class names that match regular expression " + this.patternDescription;
    }
}

