/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCache;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheEditor;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.CorruptObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.DirCacheNameConflictException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.Command;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.FileMode;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdRef;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectInserter;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.SymbolicRef;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevTree;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.ReceiveCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;

public class RefTree {
    public static final String PEELED_SUFFIX = " ^";
    static final String ROOT_DOTDOT = "..";
    private DirCache contents;
    private Map<ObjectId, String> pendingBlobs;

    public static RefTree newEmptyTree() {
        return new RefTree(DirCache.newInCore());
    }

    public static RefTree read(ObjectReader reader, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return new RefTree(DirCache.read(reader, tree));
    }

    private RefTree(DirCache dc) {
        this.contents = dc;
    }

    @Nullable
    public Ref exactRef(ObjectReader reader, String name) throws IOException {
        Ref r = this.readRef(reader, name);
        if (r == null) {
            return null;
        }
        if (r.isSymbolic()) {
            return this.resolve(reader, r, 0);
        }
        DirCacheEntry p = this.contents.getEntry(RefTree.peeledPath(name));
        if (p != null && p.getRawMode() == 57344) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, r.getName(), r.getObjectId(), p.getObjectId());
        }
        return r;
    }

    private Ref readRef(ObjectReader reader, String name) throws IOException {
        DirCacheEntry e = this.contents.getEntry(RefTree.refPath(name));
        return e != null ? this.toRef(reader, e, name) : null;
    }

    private Ref toRef(ObjectReader reader, DirCacheEntry e, String name) throws IOException {
        int mode = e.getRawMode();
        if (mode == 57344) {
            ObjectId id = e.getObjectId();
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id);
        }
        if (mode == 40960) {
            String n;
            ObjectId id = e.getObjectId();
            String string = n = this.pendingBlobs != null ? this.pendingBlobs.get(id) : null;
            if (n == null) {
                byte[] bin = reader.open(id, 3).getCachedBytes();
                n = RawParseUtils.decode(bin);
            }
            ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, n, null);
            return new SymbolicRef(name, dst);
        }
        return null;
    }

    private Ref resolve(ObjectReader reader, Ref ref, int depth) throws IOException {
        if (ref.isSymbolic() && depth < 5) {
            Ref r = this.readRef(reader, ref.getTarget().getName());
            if (r == null) {
                return ref;
            }
            Ref dst = this.resolve(reader, r, depth + 1);
            return new SymbolicRef(ref.getName(), dst);
        }
        return ref;
    }

    public boolean apply(Collection<Command> cmdList) {
        try {
            DirCacheEditor ed = this.contents.editor();
            for (Command cmd : cmdList) {
                if (!RefTree.isValidRef(cmd)) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().funnyRefname);
                    Command.abort(cmdList, null);
                    return false;
                }
                this.apply(ed, cmd);
            }
            ed.finish();
            return true;
        }
        catch (DirCacheNameConflictException e) {
            String r1 = RefTree.refName(e.getPath1());
            String r2 = RefTree.refName(e.getPath2());
            for (Command cmd : cmdList) {
                if (!r1.equals(cmd.getRefName()) && !r2.equals(cmd.getRefName())) continue;
                cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                break;
            }
            Command.abort(cmdList, null);
            return false;
        }
        catch (LockFailureException e) {
            Command.abort(cmdList, null);
            return false;
        }
    }

    private static boolean isValidRef(Command cmd) {
        String n = cmd.getRefName();
        return "HEAD".equals(n) || Repository.isValidRefName(n);
    }

    private void apply(DirCacheEditor ed, final Command cmd) {
        String path = RefTree.refPath(cmd.getRefName());
        Ref oldRef = cmd.getOldRef();
        final Ref newRef = cmd.getNewRef();
        if (newRef == null) {
            RefTree.checkRef(this.contents.getEntry(path), cmd);
            ed.add(new DirCacheEditor.DeletePath(path));
            RefTree.cleanupPeeledRef(ed, oldRef);
            return;
        }
        if (newRef.isSymbolic()) {
            final String dst = newRef.getTarget().getName();
            ed.add(new DirCacheEditor.PathEdit(path){

                @Override
                public void apply(DirCacheEntry ent) {
                    RefTree.checkRef(ent, cmd);
                    ObjectId id = Command.symref(dst);
                    ent.setFileMode(FileMode.SYMLINK);
                    ent.setObjectId(id);
                    if (RefTree.this.pendingBlobs == null) {
                        RefTree.this.pendingBlobs = new HashMap(4);
                    }
                    RefTree.this.pendingBlobs.put(id, dst);
                }
            }.setReplace(false));
            RefTree.cleanupPeeledRef(ed, oldRef);
            return;
        }
        ed.add(new DirCacheEditor.PathEdit(path){

            @Override
            public void apply(DirCacheEntry ent) {
                RefTree.checkRef(ent, cmd);
                ent.setFileMode(FileMode.GITLINK);
                ent.setObjectId(newRef.getObjectId());
            }
        }.setReplace(false));
        if (newRef.getPeeledObjectId() != null) {
            ed.add(new DirCacheEditor.PathEdit(RefTree.peeledPath(newRef.getName())){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.GITLINK);
                    ent.setObjectId(newRef.getPeeledObjectId());
                }
            }.setReplace(false));
        } else {
            RefTree.cleanupPeeledRef(ed, oldRef);
        }
    }

    private static void checkRef(@Nullable DirCacheEntry ent, Command cmd) {
        if (!cmd.checkRef(ent)) {
            cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            throw new LockFailureException();
        }
    }

    private static void cleanupPeeledRef(DirCacheEditor ed, Ref ref) {
        if (!(ref == null || ref.isSymbolic() || ref.isPeeled() && ref.getPeeledObjectId() == null)) {
            ed.add(new DirCacheEditor.DeletePath(RefTree.peeledPath(ref.getName())));
        }
    }

    public static String refName(String path) {
        if (path.startsWith(ROOT_DOTDOT)) {
            return path.substring(2);
        }
        return "refs/" + path;
    }

    static String refPath(String name) {
        if (name.startsWith("refs/")) {
            return name.substring("refs/".length());
        }
        return ROOT_DOTDOT + name;
    }

    private static String peeledPath(String name) {
        return RefTree.refPath(name) + PEELED_SUFFIX;
    }

    public ObjectId writeTree(ObjectInserter inserter) throws IOException {
        if (this.pendingBlobs != null) {
            for (String s : this.pendingBlobs.values()) {
                inserter.insert(3, Constants.encode(s));
            }
            this.pendingBlobs = null;
        }
        return this.contents.writeTree(inserter);
    }

    public RefTree copy() {
        RefTree r = new RefTree(DirCache.newInCore());
        DirCacheBuilder b = r.contents.builder();
        for (int i = 0; i < this.contents.getEntryCount(); ++i) {
            b.add(new DirCacheEntry(this.contents.getEntry(i)));
        }
        b.finish();
        if (this.pendingBlobs != null) {
            r.pendingBlobs = new HashMap<ObjectId, String>(this.pendingBlobs);
        }
        return r;
    }

    private static class LockFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private LockFailureException() {
        }
    }
}

