/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.IntSet;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.FileMode;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.MutableObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectLoader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevTree;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.CanonicalTreeParser;

class BaseSearch {
    private static final int M_BLOB = FileMode.REGULAR_FILE.getBits();
    private static final int M_TREE = FileMode.TREE.getBits();
    private final ProgressMonitor progress;
    private final ObjectReader reader;
    private final ObjectId[] baseTrees;
    private final ObjectIdOwnerMap<ObjectToPack> objectsMap;
    private final List<ObjectToPack> edgeObjects;
    private final IntSet alreadyProcessed;
    private final ObjectIdOwnerMap<TreeWithData> treeCache;
    private final CanonicalTreeParser parser;
    private final MutableObjectId idBuf;

    BaseSearch(ProgressMonitor countingMonitor, Set<RevTree> bases, ObjectIdOwnerMap<ObjectToPack> objects, List<ObjectToPack> edges, ObjectReader or) {
        this.progress = countingMonitor;
        this.reader = or;
        this.baseTrees = bases.toArray(new ObjectId[bases.size()]);
        this.objectsMap = objects;
        this.edgeObjects = edges;
        this.alreadyProcessed = new IntSet();
        this.treeCache = new ObjectIdOwnerMap();
        this.parser = new CanonicalTreeParser();
        this.idBuf = new MutableObjectId();
    }

    void addBase(int objectType, byte[] pathBuf, int pathLen, int pathHash) throws IOException {
        int tailMode = BaseSearch.modeForType(objectType);
        if (tailMode == 0) {
            return;
        }
        if (!this.alreadyProcessed.add(pathHash)) {
            return;
        }
        if (pathLen == 0) {
            for (ObjectId root : this.baseTrees) {
                this.add(root, 2, pathHash);
            }
            return;
        }
        int firstSlash = BaseSearch.nextSlash(pathBuf, 0, pathLen);
        block1: for (ObjectId root : this.baseTrees) {
            int ptr = 0;
            int end = firstSlash;
            int mode = end != pathLen ? M_TREE : tailMode;
            this.parser.reset(this.readTree(root));
            while (!this.parser.eof()) {
                int cmp = this.parser.pathCompare(pathBuf, ptr, end, mode);
                if (cmp < 0) {
                    this.parser.next();
                    continue;
                }
                if (cmp > 0) continue block1;
                if (end == pathLen) {
                    if (this.parser.getEntryFileMode().getObjectType() != objectType) continue block1;
                    this.idBuf.fromRaw(this.parser.idBuffer(), this.parser.idOffset());
                    this.add(this.idBuf, objectType, pathHash);
                    continue block1;
                }
                if (!FileMode.TREE.equals(this.parser.getEntryRawMode())) continue block1;
                ptr = end + 1;
                mode = (end = BaseSearch.nextSlash(pathBuf, ptr, pathLen)) != pathLen ? M_TREE : tailMode;
                this.idBuf.fromRaw(this.parser.idBuffer(), this.parser.idOffset());
                this.parser.reset(this.readTree(this.idBuf));
            }
        }
    }

    private static int modeForType(int typeCode) {
        switch (typeCode) {
            case 2: {
                return M_TREE;
            }
            case 3: {
                return M_BLOB;
            }
        }
        return 0;
    }

    private static int nextSlash(byte[] pathBuf, int ptr, int end) {
        while (ptr < end && pathBuf[ptr] != 47) {
            ++ptr;
        }
        return ptr;
    }

    private void add(AnyObjectId id, int objectType, int pathHash) {
        ObjectToPack obj = new ObjectToPack(id, objectType);
        obj.setEdge();
        obj.setPathHash(pathHash);
        if (this.objectsMap.addIfAbsent(obj) == obj) {
            this.edgeObjects.add(obj);
            this.progress.update(1);
        }
    }

    private byte[] readTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        TreeWithData tree = this.treeCache.get(id);
        if (tree != null) {
            return tree.buf;
        }
        ObjectLoader ldr = this.reader.open(id, 2);
        byte[] buf = ldr.getCachedBytes(Integer.MAX_VALUE);
        this.treeCache.add(new TreeWithData(id, buf));
        return buf;
    }

    private static class TreeWithData
    extends ObjectIdOwnerMap.Entry {
        final byte[] buf;

        TreeWithData(AnyObjectId id, byte[] buf) {
            super(id);
            this.buf = buf;
        }
    }
}

