/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactUtils;
import org.gradle.internal.impldep.org.apache.maven.model.Dependency;
import org.gradle.internal.impldep.org.apache.maven.model.Extension;
import org.gradle.internal.impldep.org.apache.maven.model.Parent;
import org.gradle.internal.impldep.org.apache.maven.model.Plugin;
import org.gradle.internal.impldep.org.apache.maven.project.DuplicateProjectException;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.CycleDetectedException;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.DAG;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.TopologicalSorter;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSorter {
    private DAG dag = new DAG();
    private List<MavenProject> sortedProjects;
    private Map<String, MavenProject> projectMap;
    private MavenProject topLevelProject;

    public ProjectSorter(List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        String projectId;
        this.projectMap = new HashMap<String, MavenProject>(projects.size() * 2);
        HashMap<String, Map<String, Vertex>> vertexMap = new HashMap<String, Map<String, Vertex>>(projects.size() * 2);
        for (MavenProject project : projects) {
            projectId = ProjectSorter.getId(project);
            MavenProject conflictingProject = this.projectMap.put(projectId, project);
            if (conflictingProject != null) {
                throw new DuplicateProjectException(projectId, conflictingProject.getFile(), project.getFile(), "Project '" + projectId + "' is duplicated in the reactor");
            }
            String projectKey = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            HashMap<String, Vertex> vertices = (HashMap<String, Vertex>)vertexMap.get(projectKey);
            if (vertices == null) {
                vertices = new HashMap<String, Vertex>(2, 1.0f);
                vertexMap.put(projectKey, vertices);
            }
            vertices.put(project.getVersion(), this.dag.addVertex(projectId));
        }
        for (Vertex projectVertex : this.dag.getVerticies()) {
            List<Extension> buildExtensions;
            List<Plugin> buildPlugins;
            projectId = projectVertex.getLabel();
            MavenProject project = this.projectMap.get(projectId);
            for (Dependency dependency : project.getDependencies()) {
                this.addEdge(this.projectMap, vertexMap, project, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, false);
            }
            Parent parent = project.getModel().getParent();
            if (parent != null) {
                this.addEdge(this.projectMap, vertexMap, null, projectVertex, parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), true, false);
            }
            if ((buildPlugins = project.getBuildPlugins()) != null) {
                for (Plugin plugin : buildPlugins) {
                    this.addEdge(this.projectMap, vertexMap, project, projectVertex, plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), false, true);
                    for (Dependency dependency : plugin.getDependencies()) {
                        this.addEdge(this.projectMap, vertexMap, project, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, true);
                    }
                }
            }
            if ((buildExtensions = project.getBuildExtensions()) == null) continue;
            for (Extension extension : buildExtensions) {
                this.addEdge(this.projectMap, vertexMap, project, projectVertex, extension.getGroupId(), extension.getArtifactId(), extension.getVersion(), false, true);
            }
        }
        ArrayList<MavenProject> sortedProjects = new ArrayList<MavenProject>(projects.size());
        List sortedProjectLabels = TopologicalSorter.sort(this.dag);
        for (String id : sortedProjectLabels) {
            sortedProjects.add(this.projectMap.get(id));
        }
        this.sortedProjects = Collections.unmodifiableList(sortedProjects);
    }

    private void addEdge(Map<String, MavenProject> projectMap, Map<String, Map<String, Vertex>> vertexMap, MavenProject project, Vertex projectVertex, String groupId, String artifactId, String version, boolean force, boolean safe) throws CycleDetectedException {
        String projectKey = ArtifactUtils.versionlessKey(groupId, artifactId);
        Map<String, Vertex> vertices = vertexMap.get(projectKey);
        if (vertices != null) {
            if (this.isSpecificVersion(version)) {
                Vertex vertex = vertices.get(version);
                if (vertex != null) {
                    this.addEdge(projectVertex, vertex, project, projectMap, force, safe);
                }
            } else {
                for (Vertex vertex : vertices.values()) {
                    this.addEdge(projectVertex, vertex, project, projectMap, force, safe);
                }
            }
        }
    }

    private void addEdge(Vertex fromVertex, Vertex toVertex, MavenProject fromProject, Map<String, MavenProject> projectMap, boolean force, boolean safe) throws CycleDetectedException {
        block5: {
            if (fromVertex.equals(toVertex)) {
                return;
            }
            if (fromProject != null) {
                MavenProject toProject = projectMap.get(toVertex.getLabel());
                fromProject.addProjectReference(toProject);
            }
            if (force && toVertex.getChildren().contains(fromVertex)) {
                this.dag.removeEdge(toVertex, fromVertex);
            }
            try {
                this.dag.addEdge(fromVertex, toVertex);
            }
            catch (CycleDetectedException e) {
                if (safe) break block5;
                throw e;
            }
        }
    }

    private boolean isSpecificVersion(String version) {
        return !StringUtils.isEmpty(version) && !version.startsWith("[") && !version.startsWith("(");
    }

    public MavenProject getTopLevelProject() {
        if (this.topLevelProject == null) {
            Iterator<MavenProject> i = this.sortedProjects.iterator();
            while (i.hasNext() && this.topLevelProject == null) {
                MavenProject project = i.next();
                if (!project.isExecutionRoot()) continue;
                this.topLevelProject = project;
            }
        }
        return this.topLevelProject;
    }

    public List<MavenProject> getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List<String> getDependents(String id) {
        return this.dag.getParentLabels(id);
    }

    public List<String> getDependencies(String id) {
        return this.dag.getChildLabels(id);
    }

    public static String getId(MavenProject project) {
        return ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public DAG getDAG() {
        return this.dag;
    }

    public Map<String, MavenProject> getProjectMap() {
        return this.projectMap;
    }
}

