/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.esotericsoftware.kryo.serializers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.Kryo;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.KryoException;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Input;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.gradle.internal.impldep.com.esotericsoftware.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    protected void initializeCachedFields() {
        int i;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (i = 0; i < n; ++i) {
            Field field = fields[i].getField();
            Tag tag = field.getAnnotation(Tag.class);
            Deprecated deprecated = field.getAnnotation(Deprecated.class);
            if (tag != null && deprecated == null) continue;
            if (Log.TRACE) {
                if (tag == null) {
                    Log.trace("kryo", "Ignoring field without tag: " + fields[i]);
                } else {
                    Log.trace("kryo", "Ignoring deprecated field: " + fields[i]);
                }
            }
            super.removeField(field.getName());
        }
        fields = this.getFields();
        this.tags = new int[fields.length];
        n = fields.length;
        for (i = 0; i < n; ++i) {
            this.tags[i] = fields[i].getField().getAnnotation(Tag.class).value();
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeInt(fields.length, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            output.writeInt(this.tags[i], true);
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = kryo.newInstance(type);
        kryo.reference(object);
        int fieldCount = input.readInt(true);
        int[] tags = this.tags;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fieldCount;
        for (int i = 0; i < n; ++i) {
            int tag = input.readInt(true);
            FieldSerializer.CachedField cachedField = null;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields[ii];
                break;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

