/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.AmazonWebServiceResponse;
import org.gradle.internal.impldep.com.amazonaws.ResponseMetadata;
import org.gradle.internal.impldep.com.amazonaws.http.HttpResponse;
import org.gradle.internal.impldep.com.amazonaws.http.HttpResponseHandler;
import org.gradle.internal.impldep.com.amazonaws.transform.StaxUnmarshallerContext;
import org.gradle.internal.impldep.com.amazonaws.transform.Unmarshaller;
import org.gradle.internal.impldep.com.amazonaws.transform.VoidStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.util.StringUtils;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"org.gradle.internal.impldep.com.amazonaws.request");
    private static final XMLInputFactory xmlInputFactory = StaxResponseHandler.createXmlInputFactory();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        log.trace((Object)"Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            try {
                eventReader = xmlInputFactory.createXMLEventReader(content);
            }
            catch (XMLStreamException e) {
                throw this.handleXmlStreamException(e);
            }
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            Map<String, String> responseHeaders = response.getHeaders();
            if (responseHeaders != null && responseHeaders.get("x-amzn-RequestId") != null) {
                metadata.put("AWS_REQUEST_ID", responseHeaders.get("x-amzn-RequestId"));
            }
            awsResponse.setResponseMetadata(this.getResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        catch (XMLStreamException e) {
            throw this.handleXmlStreamException(e);
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.warn((Object)"Error closing xml parser", (Throwable)e);
            }
        }
    }

    private Exception handleXmlStreamException(XMLStreamException e) throws Exception {
        if (e.getNestedException() instanceof IOException) {
            return new IOException(e);
        }
        return e;
    }

    protected ResponseMetadata getResponseMetadata(Map<String, String> metadata) {
        return new ResponseMetadata(metadata);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    }
}

