/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.commons.util.codec.URLCodec;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class URL {
    private String protocol;
    private String username;
    private String password;
    private String host;
    private Integer port;
    private String path;
    private String query;
    private Properties queryProperties;

    public String toString() {
        StringBuilder url = new StringBuilder();
        if (!StringUtil.isEmpty(this.protocol)) {
            url.append(this.protocol);
            url.append("://");
        }
        if (!StringUtil.isEmpty(this.username)) {
            url.append(URL.encode(this.username));
            if (this.password != null) {
                url.append(':');
                url.append(URL.encode(this.password));
            }
            url.append('@');
        }
        if (!StringUtil.isEmpty(this.host)) {
            url.append(this.host);
        }
        if (this.port != null) {
            url.append(':');
            url.append(this.port);
        }
        if (!StringUtil.isEmpty(this.path)) {
            url.append(this.path);
        }
        if (!StringUtil.isEmpty(this.query)) {
            url.append('?');
            url.append(this.query);
        }
        return url.toString();
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String value) throws MalformedURLException {
        if (this.queryProperties == null) {
            this.queryProperties = new Properties();
        }
        URL.parseQueryProperties(value, this.queryProperties);
        this.query = value;
    }

    public String getQueryProperty(String name) {
        if (this.queryProperties == null) {
            return null;
        }
        return this.queryProperties.getProperty(name);
    }

    public Properties getQueryProperties() {
        return this.queryProperties;
    }

    public static void parseQueryProperties(String q, Properties props) throws MalformedURLException {
        if (q == null || q.length() == 0) {
            return;
        }
        StringTokenizer iter = new StringTokenizer(q, "&");
        while (iter.hasMoreElements()) {
            String pair = iter.nextToken();
            int split = pair.indexOf(61);
            if (split <= 0) {
                throw new RuntimeException("Invalid pair [" + pair + "] in query string [" + q + "]");
            }
            String tempKey = pair.substring(0, split);
            String tempValue = pair.substring(split + 1);
            StringBuilder key = new StringBuilder(tempKey.length());
            StringBuilder value = new StringBuilder(tempValue.length());
            try {
                URLCodec.decode((CharSequence)tempKey, key);
                URLCodec.decode((CharSequence)tempValue, value);
            }
            catch (IOException e) {
                throw new MalformedURLException("Invalid encoding in [" + pair + "] in query string [" + q + "]");
            }
            props.setProperty(key.toString(), value.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof URL) {
            URL otherURL = (URL)object;
            String otherURLString = otherURL.toString();
            return this.toString().equals(otherURLString);
        }
        if (object instanceof String) {
            String otherURLString = (String)object;
            return this.toString().equals(otherURLString);
        }
        return false;
    }

    public int hashCode() {
        String urlString = this.toString();
        int hash = 7;
        hash = 79 * hash + (urlString != null ? urlString.hashCode() : 0);
        return hash;
    }

    private static String encode(String str0) throws IllegalArgumentException {
        StringBuilder buf = new StringBuilder(str0.length());
        try {
            URLCodec.encode(str0, (Appendable)buf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid param: URL encoding '" + str0 + "'");
        }
        return buf.toString();
    }
}

