/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanProperty {
    private String name;
    private Class type;
    private Field field;
    Method getMethod;
    Method setMethod;
    Method addMethod;

    public BeanProperty(String name, Class type, Field field) {
        this.name = name;
        this.type = type;
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean canAdd() {
        return this.addMethod != null;
    }

    public boolean canAddOrSet() {
        return this.canAdd() || this.canSet();
    }

    public boolean canGet() {
        return this.getMethod != null || this.field != null;
    }

    public boolean canSet() {
        return this.setMethod != null || this.field != null;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public Method getAddMethod() {
        return this.addMethod;
    }

    public void set(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.setMethod != null) {
            this.setMethod.invoke(obj, value);
        } else if (this.field != null) {
            this.field.set(obj, value);
        } else {
            throw new IllegalAccessException("Cannot set property value");
        }
    }

    public Object get(Object obj) throws IllegalAccessException, InvocationTargetException {
        if (this.getMethod != null) {
            return this.getMethod.invoke(obj, new Object[0]);
        }
        if (this.field != null) {
            return this.field.get(obj);
        }
        throw new IllegalAccessException("Cannot get property value");
    }

    public void add(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.addMethod == null) {
            throw new IllegalAccessException("Cannot add property value");
        }
        this.addMethod.invoke(obj, value);
    }

    public void addOrSet(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.addMethod != null) {
            this.addMethod.invoke(obj, value);
        } else if (this.setMethod != null) {
            this.setMethod.invoke(obj, value);
        } else if (this.field != null) {
            this.field.set(obj, value);
        } else {
            throw new IllegalAccessException("Cannot add or set the property");
        }
    }
}

