/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;
import org.traccar.protocol.WatchProtocolDecoder;

public class WatchProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    private static Map<Byte, Byte> mapping = new HashMap<Byte, Byte>();

    @Override
    public String formatValue(String key, Object value) {
        if (key.equals("timezone")) {
            double offset = (double)TimeZone.getTimeZone((String)value).getRawOffset() / 3600000.0;
            DecimalFormat fmt = new DecimalFormat("+#.##;-#.##", DecimalFormatSymbols.getInstance(Locale.US));
            return fmt.format(offset);
        }
        if (key.equals("message")) {
            return DataConverter.printHex(value.toString().getBytes(StandardCharsets.UTF_16BE));
        }
        return null;
    }

    protected String formatCommand(Channel channel, Command command, String format, String ... keys) {
        WatchProtocolDecoder decoder;
        boolean hasIndex = false;
        String manufacturer = "CS";
        if (channel != null && (decoder = (WatchProtocolDecoder)channel.pipeline().get(WatchProtocolDecoder.class)) != null) {
            hasIndex = decoder.getHasIndex();
            manufacturer = decoder.getManufacturer();
        }
        String content = this.formatCommand(command, format, this, keys);
        if (hasIndex) {
            return String.format("[%s*%s*0001*%04x*%s]", manufacturer, this.getUniqueId(command.getDeviceId()), content.length(), content);
        }
        return String.format("[%s*%s*%04x*%s]", manufacturer, this.getUniqueId(command.getDeviceId()), content.length(), content);
    }

    private int getEnableFlag(Command command) {
        if (command.getBoolean("enable")) {
            return 1;
        }
        return 0;
    }

    private String getBinaryData(Command command) {
        byte[] data = DataConverter.parseHex(command.getString("data"));
        int encodedLength = data.length;
        for (byte b : data) {
            if (!mapping.containsKey(b)) continue;
            ++encodedLength;
        }
        int index = 0;
        byte[] encodedData = new byte[encodedLength];
        for (byte b : data) {
            Byte replacement = mapping.get(b);
            if (replacement != null) {
                encodedData[index] = 125;
                encodedData[++index] = replacement;
            } else {
                encodedData[index] = b;
            }
            ++index;
        }
        return new String(encodedData, StandardCharsets.US_ASCII);
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(channel, command, command.getString("data"), new String[0]);
            }
            case "positionSingle": {
                return this.formatCommand(channel, command, "RG", new String[0]);
            }
            case "sosNumber": {
                return this.formatCommand(channel, command, "SOS{%s},{%s}", "index", "phone");
            }
            case "alarmSos": {
                return this.formatCommand(channel, command, "SOSSMS," + this.getEnableFlag(command), new String[0]);
            }
            case "alarmBattery": {
                return this.formatCommand(channel, command, "LOWBAT," + this.getEnableFlag(command), new String[0]);
            }
            case "rebootDevice": {
                return this.formatCommand(channel, command, "RESET", new String[0]);
            }
            case "alarmRemove": {
                return this.formatCommand(channel, command, "REMOVE," + this.getEnableFlag(command), new String[0]);
            }
            case "silenceTime": {
                return this.formatCommand(channel, command, "SILENCETIME,{%s}", "data");
            }
            case "alarmClock": {
                return this.formatCommand(channel, command, "REMIND,{%s}", "data");
            }
            case "setPhonebook": {
                return this.formatCommand(channel, command, "PHB,{%s}", "data");
            }
            case "message": {
                return this.formatCommand(channel, command, "MESSAGE,{%s}", "message");
            }
            case "voiceMessage": {
                return this.formatCommand(channel, command, "TK,%s", this.getBinaryData(command));
            }
            case "positionPeriodic": {
                return this.formatCommand(channel, command, "UPLOAD,{%s}", "frequency");
            }
            case "setTimezone": {
                return this.formatCommand(channel, command, "LZ,,{%s}", "timezone");
            }
            case "setIndicator": {
                return this.formatCommand(channel, command, "FLOWER,{%s}", "data");
            }
        }
        return null;
    }

    static {
        mapping.put((byte)125, (byte)1);
        mapping.put((byte)91, (byte)2);
        mapping.put((byte)93, (byte)3);
        mapping.put((byte)44, (byte)4);
        mapping.put((byte)42, (byte)5);
    }
}

