/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class FreematicsProtocolDecoder
extends BaseProtocolDecoder {
    public FreematicsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Object decodeEvent(Channel channel, SocketAddress remoteAddress, String sentence) {
        DeviceSession deviceSession = null;
        String event = null;
        String time = null;
        block11: for (String pair : sentence.split(",")) {
            String[] data = pair.split("=");
            String key = data[0];
            String value = data[1];
            switch (key) {
                case "ID": 
                case "VIN": {
                    if (deviceSession != null) continue block11;
                    deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                    continue block11;
                }
                case "EV": {
                    event = value;
                    continue block11;
                }
                case "TS": {
                    time = value;
                    continue block11;
                }
            }
        }
        if (channel != null && deviceSession != null && event != null && time != null) {
            String message = String.format("1#EV=%s,RX=1,TS=%s", event, time);
            message = message + '*' + Checksum.sum(message);
            channel.writeAndFlush((Object)new NetworkMessage(message, remoteAddress));
        }
        return null;
    }

    private Object decodePosition(Channel channel, SocketAddress remoteAddress, String sentence) throws Exception {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        Position position = null;
        DateBuilder dateBuilder = null;
        block15: for (String pair : sentence.split(",")) {
            String[] data = pair.split("[=:]");
            int key = Integer.parseInt(data[0], 16);
            String value = data[1];
            switch (key) {
                case 0: {
                    if (position != null) {
                        position.setTime(dateBuilder.getDate());
                        positions.add(position);
                    }
                    position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    position.setValid(true);
                    dateBuilder = new DateBuilder(new Date());
                    continue block15;
                }
                case 17: {
                    value = ("000000" + value).substring(value.length());
                    dateBuilder.setDateReverse(Integer.parseInt(value.substring(0, 2)), Integer.parseInt(value.substring(2, 4)), Integer.parseInt(value.substring(4)));
                    continue block15;
                }
                case 16: {
                    value = ("00000000" + value).substring(value.length());
                    dateBuilder.setTime(Integer.parseInt(value.substring(0, 2)), Integer.parseInt(value.substring(2, 4)), Integer.parseInt(value.substring(4, 6)), Integer.parseInt(value.substring(6)) * 10);
                    continue block15;
                }
                case 10: {
                    position.setLatitude(Double.parseDouble(value));
                    continue block15;
                }
                case 11: {
                    position.setLongitude(Double.parseDouble(value));
                    continue block15;
                }
                case 12: {
                    position.setAltitude(Double.parseDouble(value));
                    continue block15;
                }
                case 13: {
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(value)));
                    continue block15;
                }
                case 14: {
                    position.setCourse(Integer.parseInt(value));
                    continue block15;
                }
                case 15: {
                    position.set("sat", Integer.parseInt(value));
                    continue block15;
                }
                case 32: {
                    position.set("acceleration", value);
                    continue block15;
                }
                case 36: {
                    position.set("battery", (double)Integer.parseInt(value) * 0.01);
                    continue block15;
                }
                case 129: {
                    position.set("rssi", Integer.parseInt(value));
                    continue block15;
                }
                case 130: {
                    position.set("deviceTemp", (double)Integer.parseInt(value) * 0.1);
                    continue block15;
                }
                default: {
                    position.set(data[0], value);
                }
            }
        }
        if (position != null) {
            position.setTime(dateBuilder.getDate());
            positions.add(position);
        }
        return positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        int startIndex = sentence.indexOf(35);
        int endIndex = sentence.indexOf(42);
        if (startIndex > 0 && endIndex > 0) {
            if ((sentence = sentence.substring(startIndex + 1, endIndex)).startsWith("EV")) {
                return this.decodeEvent(channel, remoteAddress, sentence);
            }
            return this.decodePosition(channel, remoteAddress, sentence);
        }
        return null;
    }
}

