/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class ContinentalProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_KEEPALIVE = 0;
    public static final int MSG_STATUS = 2;
    public static final int MSG_ACK = 6;
    public static final int MSG_NACK = 21;

    public ContinentalProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private double readCoordinate(ByteBuf buf, boolean extended) {
        long value = buf.readUnsignedInt();
        if (extended ? (value & 0x8000000L) != 0L : (value & 0x800000L) != 0L) {
            value |= extended ? -268435456L : -16777216L;
        }
        return (double)((int)value) / (extended ? 360000.0 : 3600.0);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        long serialNumber = buf.readUnsignedInt();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(serialNumber));
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 2) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setFixTime(new Date(buf.readUnsignedInt() * 1000L));
            boolean extended = buf.getUnsignedByte(buf.readerIndex()) != 0;
            position.setLatitude(this.readCoordinate(buf, extended));
            position.setLongitude(this.readCoordinate(buf, extended));
            position.setCourse(buf.readUnsignedShort());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.setValid(buf.readUnsignedByte() > 0);
            position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
            position.set("event", buf.readUnsignedShort());
            int input = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(input, 0));
            position.set("input", input);
            position.set("output", buf.readUnsignedShort());
            position.set("battery", buf.readUnsignedByte());
            position.set("deviceTemp", buf.readByte());
            buf.readUnsignedShort();
            if (buf.readableBytes() > 4) {
                position.set("odometer", buf.readUnsignedInt());
            }
            if (buf.readableBytes() > 4) {
                position.set("hours", UnitsConverter.msFromHours(buf.readUnsignedInt()));
            }
            return position;
        }
        return null;
    }
}

