/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.processing;

import io.netty.channel.ChannelHandler;
import org.traccar.BaseDataHandler;
import org.traccar.Context;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class CopyAttributesHandler
extends BaseDataHandler {
    private Position getLastPosition(long deviceId) {
        if (Context.getIdentityManager() != null) {
            return Context.getIdentityManager().getLastPosition(deviceId);
        }
        return null;
    }

    @Override
    protected Position handlePosition(Position position) {
        String attributesString = Context.getDeviceManager().lookupAttributeString(position.getDeviceId(), "processing.copyAttributes", "", true);
        Position last = this.getLastPosition(position.getDeviceId());
        attributesString = attributesString.isEmpty() ? "driverUniqueId" : attributesString + ",driverUniqueId";
        if (last != null) {
            for (String attribute : attributesString.split("[ ,]")) {
                if (!last.getAttributes().containsKey(attribute) || position.getAttributes().containsKey(attribute)) continue;
                position.getAttributes().put(attribute, last.getAttributes().get(attribute));
            }
        }
        return position;
    }
}

