/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.DataManager;
import org.traccar.database.ManagableObjects;
import org.traccar.model.Group;

public class GroupsManager
extends BaseObjectManager<Group>
implements ManagableObjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupsManager.class);
    private AtomicLong groupsLastUpdate = new AtomicLong();
    private final long dataRefreshDelay = Context.getConfig().getLong("database.refreshDelay", 300L) * 1000L;

    public GroupsManager(DataManager dataManager) {
        super(dataManager, Group.class);
    }

    private void checkGroupCycles(Group group) {
        HashSet<Long> groups = new HashSet<Long>();
        while (group != null) {
            if (groups.contains(group.getId())) {
                throw new IllegalArgumentException("Cycle in group hierarchy");
            }
            groups.add(group.getId());
            group = (Group)this.getById(group.getGroupId());
        }
    }

    public void updateGroupCache(boolean force) throws SQLException {
        long lastUpdate = this.groupsLastUpdate.get();
        if ((force || System.currentTimeMillis() - lastUpdate > this.dataRefreshDelay) && this.groupsLastUpdate.compareAndSet(lastUpdate, System.currentTimeMillis())) {
            this.refreshItems();
        }
    }

    @Override
    public Set<Long> getAllItems() {
        Set<Long> result = super.getAllItems();
        if (result.isEmpty()) {
            try {
                this.updateGroupCache(true);
            }
            catch (SQLException e) {
                LOGGER.warn("Update group cache error", (Throwable)e);
            }
            result = super.getAllItems();
        }
        return result;
    }

    @Override
    protected void addNewItem(Group group) {
        this.checkGroupCycles(group);
        super.addNewItem(group);
    }

    @Override
    public void updateItem(Group group) throws SQLException {
        this.checkGroupCycles(group);
        super.updateItem(group);
    }

    @Override
    public Set<Long> getUserItems(long userId) {
        if (Context.getPermissionsManager() != null) {
            return Context.getPermissionsManager().getGroupPermissions(userId);
        }
        return new HashSet<Long>();
    }

    @Override
    public Set<Long> getManagedItems(long userId) {
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(this.getUserItems(userId));
        for (long managedUserId : Context.getUsersManager().getUserItems(userId)) {
            result.addAll(this.getUserItems(managedUserId));
        }
        return result;
    }
}

