/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PSWTText
extends PNode {
    protected static final double DEFAULT_GREEK_THRESHOLD = 5.5;
    protected static final Color DEFAULT_GREEK_COLOR = Color.gray;
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final int DEFAULT_FONT_STYLE = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    protected static final Color DEFAULT_PEN_COLOR = Color.black;
    protected static final String DEFAULT_TEXT = "";
    protected static final int DEFAULT_PADDING = 2;
    protected double greekThreshold = 5.5;
    protected Color greekColor = DEFAULT_GREEK_COLOR;
    protected Color penColor = DEFAULT_PEN_COLOR;
    protected Font font = DEFAULT_FONT;
    protected int padding = 2;
    protected ArrayList lines = new ArrayList();
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public PSWTText() {
        this(DEFAULT_TEXT, DEFAULT_FONT);
    }

    public PSWTText(String string) {
        this(string, DEFAULT_FONT);
    }

    public PSWTText(String string, Font font) {
        this.setText(string);
        this.font = font;
        this.recomputeBounds();
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Paint getPenPaint() {
        return this.penColor;
    }

    public void setPenPaint(Paint paint) {
        this.penColor = (Color)paint;
    }

    public Color getBackgroundColor() {
        return (Color)this.getPaint();
    }

    public void setBackgroundColor(Color color) {
        super.setPaint(color);
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double d) {
        this.greekThreshold = d;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        String string = new String();
        int n = 0;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            if (n > 0) {
                string = string + '\n';
            }
            String string2 = (String)iterator.next();
            string = string + string2;
            ++n;
        }
        return string;
    }

    public void setFont(Font font) {
        this.font = font;
        this.recomputeBounds();
    }

    public void setText(String string) {
        int n = 0;
        boolean bl = false;
        this.lines = new ArrayList();
        do {
            int n2;
            if ((n2 = string.indexOf(10, n)) == -1) {
                this.lines.add(string);
                bl = true;
                continue;
            }
            this.lines.add(string.substring(0, n2));
            string = string.substring(n2 + 1);
        } while (!bl);
        this.recomputeBounds();
    }

    public void setTranslateX(double d) {
        this.setTranslation(d, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double d) {
        this.setTranslation(this.translateX, d);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double d, double d2) {
        this.translateX = d;
        this.translateY = d2;
        this.recomputeBounds();
    }

    public void setTranslation(Point2D point2D) {
        this.setTranslation(point2D.getX(), point2D.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double double_ = new Point2D.Double(this.translateX, this.translateY);
        return double_;
    }

    public void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        AffineTransform affineTransform = null;
        boolean bl = false;
        if (!this.lines.isEmpty()) {
            double d;
            if (this.translateX != 0.0 || this.translateY != 0.0) {
                affineTransform = graphics2D.getTransform();
                graphics2D.translate(this.translateX, this.translateY);
                bl = true;
            }
            if ((d = (double)this.font.getSize() * pPaintContext.getScale()) < 0.5 || d < this.greekThreshold) {
                this.paintAsGreek(pPaintContext);
            } else {
                this.paintAsText(pPaintContext);
            }
            if (bl) {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public void paintAsGreek(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this.greekColor != null) {
            graphics2D.setBackground(this.greekColor);
            ((SWTGraphics2D)graphics2D).fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public void paintAsText(PPaintContext pPaintContext) {
        SWTGraphics2D sWTGraphics2D = (SWTGraphics2D)pPaintContext.getGraphics();
        if (this.getPaint() != null) {
            sWTGraphics2D.setBackground((Color)this.getPaint());
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
            sWTGraphics2D.fillRect(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        }
        sWTGraphics2D.translate(this.padding, this.padding);
        double d = Math.min(sWTGraphics2D.getTransform().getScaleX(), sWTGraphics2D.getTransform().getScaleY());
        double d2 = d * (double)this.font.getSize();
        double d3 = Math.floor(d2) / d2;
        sWTGraphics2D.scale(d3, d3);
        sWTGraphics2D.setColor(this.penColor);
        sWTGraphics2D.setFont(this.font);
        int n = 0;
        FontMetrics fontMetrics = sWTGraphics2D.getSWTFontMetrics();
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.equals(DEFAULT_TEXT) ? " " : string;
            double d4 = n * fontMetrics.getHeight();
            sWTGraphics2D.drawString(string, 0.0, d4);
            ++n;
        }
        sWTGraphics2D.scale(1.0 / d3, 1.0 / d3);
        sWTGraphics2D.translate(-this.padding, -this.padding);
    }

    protected void recomputeBounds() {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        if (this.lines.size() == 1 && ((String)this.lines.get(0)).equals(DEFAULT_TEXT)) {
            bl = false;
        }
        GC gC = new GC((Drawable)Display.getDefault());
        SWTGraphics2D sWTGraphics2D = new SWTGraphics2D(gC, (Device)Display.getDefault());
        sWTGraphics2D.setFont(this.font);
        FontMetrics fontMetrics = sWTGraphics2D.getSWTFontMetrics();
        if (!this.lines.isEmpty() && bl) {
            int n = 0;
            Iterator iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Point point = gC.stringExtent(string);
                double d3 = point.x;
                if (d3 > d) {
                    d = d3;
                }
                d2 = n == 0 ? (d2 += (double)(fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading())) : (d2 += (double)fontMetrics.getHeight());
                ++n;
            }
        } else {
            Point point = gC.stringExtent(" ");
            d = point.x;
            d2 = point.y;
        }
        gC.dispose();
        this.setBounds(this.translateX, this.translateY, d + 4.0, d2 + 4.0);
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        this.recomputeBounds();
    }
}

